/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.example.quotes;

import com.webullpay.openapi.common.dict.Category;
import com.webullpay.openapi.common.dict.Timespan;
import com.webullpay.openapi.example.config.Env;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.execption.ServerException;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.quotes.api.QuotesApiClient;
import com.webullpay.openapi.quotes.domain.Quote;
import java.util.HashSet;
import java.util.List;

public class QuotesGrpcApi {
    private static final Logger logger = LoggerFactory.getLogger(QuotesGrpcApi.class);

    public static void main(String[] args) {
        String symbol = "BTCUSD";
        try (QuotesApiClient quotesApiClient = QuotesApiClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();){
            HashSet<String> symbols = new HashSet<String>();
            symbols.add(symbol);
            List instruments = quotesApiClient.getInstruments(symbols, Category.CRYPTO.name());
            logger.info("Instruments: {}", (Object)instruments);
            List bars = quotesApiClient.getBars(symbol, Category.CRYPTO.name(), Timespan.D.name(), 10);
            logger.info("Bars: {}", (Object)bars);
            Quote quote = quotesApiClient.getQuote(symbol, Category.CRYPTO.name());
            logger.info("Quote: {}", (Object)quote);
            List snapshots = quotesApiClient.getSnapshots(symbols, Category.CRYPTO.name());
            logger.info("Snapshots: {}", (Object)snapshots);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

