/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.example.quotes;

import com.webullpay.openapi.common.dict.Category;
import com.webullpay.openapi.common.dict.Timespan;
import com.webullpay.openapi.example.config.Env;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.execption.ServerException;
import com.webullpay.openapi.http.HttpApiConfig;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.quotes.domain.Quote;
import com.webullpay.openapi.quotes.internal.http.HttpQuotesApiClient;
import java.util.HashSet;
import java.util.List;

public class QuotesHttpApi {
    private static final Logger logger = LoggerFactory.getLogger(QuotesHttpApi.class);

    public static void main(String[] args) {
        HashSet<String> symbols = new HashSet<String>();
        symbols.add("BTCUSD");
        symbols.add("PEPEUSD");
        HttpApiConfig apiConfig = HttpApiConfig.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).build();
        try (HttpQuotesApiClient quotesApiClient = new HttpQuotesApiClient(apiConfig);){
            List instruments = quotesApiClient.getInstruments(symbols, Category.CRYPTO.name());
            logger.info("Instruments: {}", (Object)instruments);
            List bars = quotesApiClient.getBars("BTCUSD", Category.CRYPTO.name(), Timespan.D.name(), 200);
            logger.info("Bars: {}", (Object)bars);
            List snapshots = quotesApiClient.getSnapshots(symbols, Category.CRYPTO.name());
            logger.info("Snapshots: {}", (Object)snapshots);
            Quote quote = quotesApiClient.getQuote("BTCUSD", Category.CRYPTO.name());
            logger.info("Quote: {}", (Object)quote);
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }
}

