/*
 * Decompiled with CFR 0.152.
 */
package com.webullpay.openapi.example.trade;

import com.google.common.reflect.TypeToken;
import com.webullpay.openapi.example.config.Env;
import com.webullpay.openapi.execption.ClientException;
import com.webullpay.openapi.execption.ServerException;
import com.webullpay.openapi.logger.Logger;
import com.webullpay.openapi.logger.LoggerFactory;
import com.webullpay.openapi.serialize.JsonSerializer;
import com.webullpay.openapi.trade.events.subscribe.EventClient;
import com.webullpay.openapi.trade.events.subscribe.Subscription;
import com.webullpay.openapi.trade.events.subscribe.message.EventType;
import com.webullpay.openapi.trade.events.subscribe.message.SubscribeRequest;
import com.webullpay.openapi.trade.events.subscribe.message.SubscribeResponse;
import java.lang.reflect.Type;
import java.util.Map;

public class TradeEvents {
    private static final Logger logger = LoggerFactory.getLogger(TradeEvents.class);

    public static void main(String[] args) {
        try (EventClient client = EventClient.builder().appKey("<your_app_key>").appSecret("<your_app_secret>").regionId(Env.REGION_ID).onMessage(TradeEvents::handleEventMessage).build();){
            SubscribeRequest request = new SubscribeRequest(new String[]{"<your_account_id>"});
            Subscription subscription = client.subscribe(request);
            subscription.blockingAwait();
        }
        catch (ClientException ex) {
            logger.error("Client error", (Throwable)ex);
        }
        catch (ServerException ex) {
            logger.error("Sever error", (Throwable)ex);
        }
        catch (Exception ex) {
            logger.error("Unknown error", (Throwable)ex);
        }
    }

    private static void handleEventMessage(SubscribeResponse response) {
        if ("application/json".equals(response.getContentType())) {
            Map payload = (Map)JsonSerializer.fromJson((String)response.getPayload(), (Type)new TypeToken<Map<String, String>>(){}.getType());
            if (EventType.Order.getCode() == response.getEventType()) {
                logger.info("--------", (Object)response.getRequestId());
                logger.info((String)payload.get("account_id"));
                logger.info((String)payload.get("client_order_id"));
                logger.info((String)payload.get("order_status"));
            }
        }
    }
}

