/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.transport.impl;

import com.wedeploy.api.sdk.ContentType;
import com.wedeploy.api.sdk.Request;
import com.wedeploy.api.sdk.Response;
import com.wedeploy.api.sdk.ResponseImpl;
import com.wedeploy.api.transport.impl.BlockingTransport;
import java.util.List;
import java.util.stream.Collectors;
import jodd.http.Cookie;
import jodd.http.HttpBrowser;
import jodd.http.HttpRequest;
import jodd.http.HttpResponse;

public class JoddHttpTransport
extends BlockingTransport {
    public Response send(Request request) {
        String url = request.url();
        HttpRequest httpRequest = new HttpRequest().method(request.method()).set(url);
        List<Cookie> cookies = request.cookies().values().stream().map(cookie -> new Cookie(cookie.encode())).collect(Collectors.toList());
        httpRequest.cookies(cookies.toArray(new Cookie[cookies.size()]));
        request.headers().forEach(header -> {
            HttpRequest cfr_ignored_0 = (HttpRequest)httpRequest.header((String)header.getKey(), (String)header.getValue());
        });
        request.params().forEach(param -> httpRequest.query((String)param.getKey(), (String)param.getValue()));
        request.forms().forEach(param -> {
            HttpRequest cfr_ignored_0 = (HttpRequest)httpRequest.form((String)param.getKey(), param.getValue());
        });
        String body = request.body();
        if (body != null) {
            String contentTypeString = request.contentType();
            ContentType contentType = ContentType.TEXT;
            if (contentTypeString != null) {
                contentType = new ContentType(contentTypeString);
            }
            httpRequest.bodyText(body, contentType.contentType(), contentType.charset());
        }
        HttpBrowser httpBrowser = new HttpBrowser();
        HttpResponse response = httpBrowser.sendRequest(httpRequest);
        ResponseImpl clientResponse = new ResponseImpl(request);
        clientResponse.status(response.statusCode(), response.statusPhrase());
        clientResponse.body(response.bodyText());
        response.headers().forEach(header -> clientResponse.headers().add((String)header.getKey(), header.getValue()));
        return clientResponse;
    }
}

