/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the
 * GNU Lesser General Public License as published by the Free Software Foundation; either version
 * 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without
 * even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 */

package com.wedeploy.api.sdk;
public interface Error<T> {

	/**
	 * Injects error into the target, usually the http response.
	 * Sets status code, message, headers and body.
	 * @param response target response to set
	 * @return the target instance
	 */
	T into(T response);

	/**
	 * Sets the error reason and message.
	 * @param reason the short reason code of the error
	 * @param message the human friendly description of the error
	 * @return this error instance for chaining
	 */
	Error error(String reason, String message);

	/**
	 * Adds header data.
	 * @param name header name
	 * @param value header value
	 * @return this error instance for chaining
	 */
	Error header(String name, String value);

	/**
	 * Accumulates the errors into the {@link ErrorData} instance.
	 * @return error data
	 */
	ErrorData<T> data();

}
