/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.log;

import com.wedeploy.api.WeDeployException;
import com.wedeploy.api.log.Logger;
import com.wedeploy.api.log.LoggerFactoryInterface;

public class LoggerFactory {
    protected static String defaultClassName = LoggerFactory.class.getPackage().getName() + ".impl.LoggerImpl";
    private static LoggerFactoryInterface loggerFactory;

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static Logger getLogger(String name) {
        LoggerFactory.initLoggerFactory();
        return loggerFactory.getLogger(name);
    }

    public static void setDefaultImplClass(String className) {
        defaultClassName = className;
    }

    public static void setLoggerFactory(LoggerFactoryInterface loggerFactory) {
        LoggerFactory.loggerFactory = loggerFactory;
    }

    protected LoggerFactory() {
    }

    private static void initLoggerFactory() {
        if (loggerFactory != null) {
            return;
        }
        Class<LoggerFactory> clazz = LoggerFactory.class;
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?> loggerClass = null;
        try {
            loggerClass = classLoader.loadClass(defaultClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new WeDeployException("Logger implementation not found: " + defaultClassName, cnfe);
        }
        try {
            loggerFactory = (LoggerFactoryInterface)loggerClass.newInstance();
        }
        catch (Exception e) {
            throw new WeDeployException("Invalid Logger implementation: " + defaultClassName, e);
        }
    }
}

