/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.WeDeploy;
import com.wedeploy.api.WeDeployException;
import com.wedeploy.api.sdk.AuthImpl;
import java.util.Collection;

public interface Auth {
    public static Auth create(String token) {
        return new AuthImpl(token);
    }

    public static Auth create(String email, String password) {
        return new AuthImpl(email, password);
    }

    public static Auth master() {
        if (WeDeploy.MASTER_TOKEN == null) {
            throw new WeDeployException("Master token is not available. To use this method, set a value for WeDeploy.MASTER_TOKEN.");
        }
        return new AuthImpl(WeDeploy.MASTER_TOKEN);
    }

    public String email();

    default public boolean hasEmail() {
        String email = this.email();
        return email != null && !email.isEmpty();
    }

    default public boolean hasId() {
        String id = this.id();
        return id != null && !id.isEmpty();
    }

    default public boolean hasName() {
        String name = this.name();
        return name != null && !name.isEmpty();
    }

    default public boolean hasPassword() {
        String password = this.password();
        return password != null && !password.isEmpty();
    }

    default public boolean hasPhotoUrl() {
        String photoUrl = this.photoUrl();
        return photoUrl != null && !photoUrl.isEmpty();
    }

    default public boolean hasScope(Collection<String> scopes) {
        return scopes.stream().map(this::hasScope).reduce(Boolean.TRUE, Boolean::logicalAnd);
    }

    public boolean hasScope(String var1);

    default public boolean hasToken() {
        String token = this.token();
        return token != null && !token.isEmpty();
    }

    public String id();

    public boolean isAuthenticated();

    default public boolean isMaster() {
        return WeDeploy.MASTER_TOKEN != null && WeDeploy.MASTER_TOKEN.equals(this.token());
    }

    public String name();

    public String password();

    public String photoUrl();

    public String token();
}

