/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

class ContentTypeHeaderResolver {
    private static final String TSPECIALS = " ;()[]<>:,=?@\"\\";
    private final String type;
    private final String encoding;

    ContentTypeHeaderResolver(String fullContentType) {
        int charsetNdx = fullContentType.lastIndexOf("charset=");
        this.encoding = charsetNdx != -1 ? this.extractContentTypeValue(fullContentType, charsetNdx + 8) : null;
        this.type = this.extractContentTypeValue(fullContentType, 0);
    }

    private String extractContentTypeValue(String type, int startIndex) {
        int endIndex;
        while (startIndex < type.length() && type.charAt(startIndex) == ' ') {
            ++startIndex;
        }
        if (startIndex >= type.length()) {
            return null;
        }
        if (type.charAt(startIndex) == '\"') {
            if ((endIndex = type.indexOf(34, ++startIndex)) == -1) {
                endIndex = type.length();
            }
        } else {
            for (endIndex = startIndex; endIndex < type.length() && TSPECIALS.indexOf(type.charAt(endIndex)) < 0; ++endIndex) {
            }
        }
        return type.substring(startIndex, endIndex);
    }

    public String getMimeType() {
        return this.type;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

