/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.WeDeployException;
import com.wedeploy.api.sdk.Auth;
import com.wedeploy.api.sdk.Base;
import com.wedeploy.api.sdk.FileUpload;
import com.wedeploy.api.sdk.MultiMap;
import com.wedeploy.api.sdk.OnResponseEndCallback;
import com.wedeploy.api.sdk.Request;
import com.wedeploy.api.sdk.Response;
import com.wedeploy.api.sdk.Session;
import java.net.URI;
import java.net.URISyntaxException;

public class RequestImpl
extends Base<Request>
implements Request {
    protected String baseUrl;
    protected FileUpload[] fileUploads;
    protected MultiMap<Object> form = MultiMap.newMultiMap();
    protected String method;
    protected MultiMap<String> params = MultiMap.newMultiMap();
    protected String path;
    protected String query;
    protected Response response;
    protected String url;

    public RequestImpl(String url) {
        this.url(url);
    }

    @Override
    public Auth auth() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    @Override
    public FileUpload[] fileUploads() {
        return this.fileUploads;
    }

    @Override
    public Object form(String name) {
        return this.form.get(name);
    }

    @Override
    public Request form(String name, Object value) {
        this.form.set(name, value);
        return this;
    }

    @Override
    public MultiMap<Object> forms() {
        return this.form;
    }

    Request fileUploads(FileUpload ... fileUploads) {
        this.fileUploads = fileUploads;
        return this;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public Request method(String method) {
        this.method = method;
        return this;
    }

    @Override
    public void next() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void next(OnResponseEndCallback onResponseEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String param(String name) {
        return this.params().get(name);
    }

    @Override
    public Request param(String name, String value) {
        this.params.set(name, value);
        return this;
    }

    @Override
    public MultiMap<String> params() {
        return this.params;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public Response response() {
        return this.response;
    }

    @Override
    public void response(Response response) {
        this.response = response;
    }

    @Override
    public Session session() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public MultiMap<Object> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T values(Class<T> type) {
        throw new UnsupportedOperationException();
    }

    private void url(String url) {
        this.url = url;
        this.baseUrl = null;
        this.path = null;
        this.query = null;
        if (url == null) {
            return;
        }
        try {
            if (url.charAt(0) == '/') {
                int separator = url.indexOf(63);
                if (separator == -1) {
                    this.path = url;
                } else {
                    this.path = url.substring(0, separator);
                    this.query = url.substring(separator + 1, url.length());
                }
            } else {
                URI parsedUrl;
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                if ((parsedUrl = new URI(url)).getHost() != null) {
                    this.baseUrl = parsedUrl.getScheme() + "://";
                    this.baseUrl = this.baseUrl + parsedUrl.getHost();
                    if (parsedUrl.getPort() != -1) {
                        this.baseUrl = this.baseUrl + ":" + parsedUrl.getPort();
                    }
                    this.path = parsedUrl.getRawPath();
                    this.query = parsedUrl.getRawQuery();
                }
            }
        }
        catch (URISyntaxException urise) {
            throw new WeDeployException("Invalid URL: " + url, urise);
        }
    }
}

