/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.transport.impl;

import com.wedeploy.api.sdk.Request;
import com.wedeploy.api.sdk.Response;
import com.wedeploy.api.transport.impl.Transport;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;

public abstract class BlockingTransport
implements Transport {
    protected final ExecutorService executor;

    @Override
    public final CompletableFuture<Response> sendAsync(Request request) {
        return CompletableFuture.supplyAsync(() -> this.send(request), this.executor);
    }

    protected BlockingTransport() {
        this(false);
    }

    protected BlockingTransport(boolean useDedicatedExecutor) {
        this.executor = useDedicatedExecutor ? Executors.newCachedThreadPool() : ForkJoinPool.commonPool();
    }

    protected BlockingTransport(int numberOfThreads) {
        this.executor = Executors.newFixedThreadPool(numberOfThreads);
    }
}

