/*
 * Decompiled with CFR 0.152.
 */
package com.wedeploy.api.sdk;

import com.wedeploy.api.WeDeployException;

public class Cookie {
    private String comment;
    private String domain;
    private String expires;
    private boolean httpOnly;
    private Long maxAge;
    private String name;
    private String path;
    private boolean secure;
    private String value;
    private Integer version;

    public static Cookie cookie(String cookie) {
        return new Cookie(cookie);
    }

    public static Cookie cookie(String name, String value) {
        return new Cookie(name, value);
    }

    public String comment() {
        return this.comment;
    }

    public Cookie comment(String comment) {
        this.comment = comment;
        return this;
    }

    public String domain() {
        return this.domain.toLowerCase();
    }

    public Cookie domain(String domain) {
        this.domain = domain;
        return this;
    }

    public String encode() {
        StringBuilder cookie = new StringBuilder();
        cookie.append(this.name).append('=').append(this.value);
        if (this.maxAge != null) {
            cookie.append("; Max-Age=").append(this.maxAge);
        }
        if (this.expires != null) {
            cookie.append("; Expires=").append(this.expires);
        }
        if (this.comment != null) {
            cookie.append("; Comment=").append(this.comment);
        }
        if (this.domain != null) {
            cookie.append("; Domain=").append(this.domain);
        }
        if (this.path != null) {
            cookie.append("; Path=").append(this.path);
        }
        if (this.secure) {
            cookie.append("; Secure");
        }
        if (this.version != null) {
            cookie.append("; Version=").append(this.version);
        }
        if (this.httpOnly) {
            cookie.append("; HttpOnly");
        }
        return cookie.toString();
    }

    public String expires() {
        return this.expires;
    }

    public Cookie expires(String expires) {
        this.expires = expires;
        return this;
    }

    public boolean httpOnly() {
        return this.httpOnly;
    }

    public Cookie httpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public Long maxAge() {
        return this.maxAge;
    }

    public Cookie maxAge(Long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String name() {
        return this.name;
    }

    public Cookie name(String name) {
        if (name.contains(";") || name.contains(",") || name.startsWith("$")) {
            throw new IllegalArgumentException("Invalid cookie name:" + name);
        }
        for (int n = 0; n < name.length(); ++n) {
            char c = name.charAt(n);
            if (c > ' ' && c < '\u007f') continue;
            throw new IllegalArgumentException("Invalid cookie name:" + name);
        }
        this.name = name;
        return this;
    }

    public String path() {
        return this.path;
    }

    public Cookie path(String path) {
        this.path = path;
        return this;
    }

    public boolean secure() {
        return this.secure;
    }

    public Cookie secure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String value() {
        return this.value;
    }

    public Cookie value(String value) {
        this.value = value;
        return this;
    }

    public Integer version() {
        return this.version;
    }

    public Cookie version(Integer version) {
        this.version = version;
        return this;
    }

    /*
     * Unable to fully structure code
     */
    protected Cookie(String cookie) {
        super();
        from = 0;
        ndx = 0;
        while (ndx < cookie.length()) {
            ndx = cookie.indexOf(59, from);
            if (ndx == -1) {
                ndx = cookie.length();
            }
            ndx2 = cookie.indexOf(61, from);
            name = null;
            value = null;
            if (ndx2 != -1 && ndx2 < ndx) {
                name = cookie.substring(from, ndx2).trim();
                value = cookie.substring(ndx2 + 1, ndx).trim();
            } else {
                name = cookie.substring(from, ndx).trim();
                value = null;
            }
            if (name.equalsIgnoreCase("Max-Age")) {
                try {
                    if (value == null) ** GOTO lbl61
                    this.maxAge(Long.parseLong(value));
                }
                catch (NumberFormatException nfe) {
                    throw new WeDeployException("Invalid cookie Max-Age: " + value);
                }
            } else if (name.equalsIgnoreCase("Comment")) {
                this.comment(value);
            } else if (name.equalsIgnoreCase("Domain")) {
                this.domain(value);
            } else if (name.equalsIgnoreCase("Path")) {
                this.path(value);
            } else if (name.equalsIgnoreCase("Secure")) {
                this.secure(true);
            } else if (name.equalsIgnoreCase("Version")) {
                try {
                    if (value == null) ** GOTO lbl61
                    this.version(Integer.parseInt(value));
                }
                catch (NumberFormatException nfe) {
                    throw new WeDeployException("Invalid cookie Version: " + value);
                }
            } else if (name.equalsIgnoreCase("HttpOnly")) {
                this.httpOnly(true);
            } else if (name.equalsIgnoreCase("Expires")) {
                this.expires(value);
            } else {
                this.name(name);
                this.value(value);
            }
lbl61:
            // 11 sources

            from = ndx + 1;
        }
    }

    protected Cookie(String name, String value) {
        this.name(name);
        this.value(value);
    }
}

