/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.carshop;

import de.beyondjava.jsf.sample.carshop.Car;
import de.beyondjava.jsf.sample.carshop.DynamicOptionBean;
import de.beyondjava.jsf.sample.carshop.FilterBean;
import de.beyondjava.jsf.sample.carshop.StaticOptionBean;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ManagedProperty;
import javax.faces.bean.SessionScoped;

@ManagedBean
@SessionScoped
public class CarPool
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int SIZE_OF_INITIAL_CAR_POOL = 10000;
    @ManagedProperty(value="#{staticOptionBean}")
    private StaticOptionBean staticOptions;
    @ManagedProperty(value="#{dynamicOptionBean}")
    private DynamicOptionBean dynamicOptions;
    private List<String> types;
    private int currentYear = Calendar.getInstance().get(1);
    private List<Car> carPool;
    private List<Car> selectedCars;

    public StaticOptionBean getStaticOptions() {
        return this.staticOptions;
    }

    public void setStaticOptions(StaticOptionBean staticOptions) {
        this.staticOptions = staticOptions;
    }

    public DynamicOptionBean getDynamicOptions() {
        return this.dynamicOptions;
    }

    public void setDynamicOptions(DynamicOptionBean dynamicOptions) {
        this.dynamicOptions = dynamicOptions;
    }

    public List<Car> getCarPool() {
        return this.carPool;
    }

    public List<Car> getSelectedCars() {
        return this.selectedCars;
    }

    @PostConstruct
    private void initRandomCarPool() {
        this.types = this.dynamicOptions.getTypesToBrand(null);
        this.carPool = new ArrayList();
        for (int i = 0; i < 10000; ++i) {
            this.carPool.add(this.getRandomCar());
        }
        this.selectedCars = this.carPool;
    }

    public void setCarPool(List<Car> carpool) {
        this.carPool = carpool;
    }

    private Car getRandomCar() {
        int typeIndex = (int)Math.floor(Math.random() * (double)(this.types.size() - 1));
        String type = (String)this.types.get(typeIndex + 1);
        String brand = this.dynamicOptions.getBrandToType(type);
        int year = (int)Math.floor((double)(this.currentYear - 1980) * Math.random()) + 1980;
        int age = this.currentYear - year;
        int price = 60000 / (1 + age) + (int)Math.floor(Math.random() * 10000.0);
        int mileage = (int)Math.floor((double)((age + 1) * 20000) * Math.random());
        int colorIndex = (int)Math.floor(Math.random() * (double)(this.staticOptions.getColors().size() - 1));
        String color = (String)this.staticOptions.getColors().get(colorIndex + 1);
        int fuelIndex = (int)Math.floor(Math.random() * (double)(this.staticOptions.getFuels().size() - 1));
        String fuel = (String)this.staticOptions.getFuels().get(fuelIndex + 1);
        Car c = new Car(brand, type, year, color, mileage, fuel, price);
        return c;
    }

    public void applyFilter(FilterBean b) {
        this.selectedCars = new ArrayList();
        for (Car c : this.carPool) {
            String criterium = b.getBrand();
            if (criterium != null && criterium.length() > 0 && !c.getBrand().equals(criterium) || (criterium = b.getType()) != null && criterium.length() > 0 && !c.getType().equals(criterium) || (criterium = b.getColor()) != null && criterium.length() > 0 && !c.getColor().equals(criterium) || (criterium = b.getFuel()) != null && criterium.length() > 0 && !c.getFuel().equals(criterium)) continue;
            int year = b.getYear();
            if (c.getYear() < year) continue;
            criterium = b.getMileage();
            if (criterium != null && criterium.length() > 0) {
                int km = Integer.parseInt(criterium.substring(2, criterium.length() - 3));
                if (c.getMileage() > km) continue;
            }
            if ((criterium = b.getPrice()) != null && criterium.length() > 0) {
                int euro = Integer.parseInt(criterium.substring(3, criterium.length()));
                if (c.getPrice() > euro) continue;
            }
            this.selectedCars.add(c);
        }
    }
}

