/*
 * Decompiled with CFR 0.152.
 */
package de.beyondjava.jsf.sample.carshop;

import de.beyondjava.jsf.sample.carshop.CarBean;
import java.io.Serializable;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.faces.application.FacesMessage;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.SessionScoped;
import javax.faces.context.FacesContext;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.Email;

@ManagedBean
@SessionScoped
public class CustomerBean
implements Serializable {
    private static final long serialVersionUID = -5843419440559883471L;
    private Date dateOfBirth;
    @Email
    private String emailAddress;
    @NotNull
    @Size(min=2, max=20)
    private String firstName;
    private boolean iAgreeToTheTermsAndConditions;
    @NotNull
    @Size(min=2, max=20)
    private String lastName;
    @NotNull
    @Min(value=100L)
    @Max(value=999L)
    private int captcha;
    private int expectedCaptcha;
    private String captchaQuestion;
    private boolean showDetails = true;

    public int getExpectedCaptcha() {
        return this.expectedCaptcha;
    }

    @PostConstruct
    private void createCaptchaQuestion() {
        this.expectedCaptcha = 100 + (int)Math.floor(900.0 * Math.random());
        int summand = (int)Math.floor((double)this.expectedCaptcha * Math.random());
        int summand2 = this.expectedCaptcha - summand;
        this.captchaQuestion = "What is " + summand + " + " + summand2 + "?";
    }

    public boolean isiAgreeToTheTermsAndConditions() {
        return this.iAgreeToTheTermsAndConditions;
    }

    public void setiAgreeToTheTermsAndConditions(boolean iAgreeToTheTermsAndConditions) {
        this.iAgreeToTheTermsAndConditions = iAgreeToTheTermsAndConditions;
    }

    public int getCaptcha() {
        return this.captcha;
    }

    public void setCaptcha(int captcha) {
        this.captcha = captcha;
    }

    public String getCaptchaQuestion() {
        return this.captchaQuestion;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public boolean isIAgreeToTheTermsAndConditions() {
        return this.iAgreeToTheTermsAndConditions;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setIAgreeToTheTermsAndConditions(boolean iAgreeToTheTermsAndConditions) {
        this.iAgreeToTheTermsAndConditions = iAgreeToTheTermsAndConditions;
    }

    public void setLastName(String lastName) {
        if (null != lastName) {
            lastName = lastName.toUpperCase();
        }
        this.lastName = lastName;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    public void buy(CarBean car) {
        FacesContext.getCurrentInstance().addMessage(null, new FacesMessage(FacesMessage.SEVERITY_INFO, "Congrats!", "Thanks for buying this car!"));
        this.showDetails = false;
    }
}

