/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.AbstractDiffer;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.DelegatingObjectDifferImpl;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.accessor.RootAccessor;
import de.danielbechler.diff.introspect.Introspector;
import de.danielbechler.diff.introspect.StandardIntrospector;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import java.util.Collections;

final class BeanDiffer
extends AbstractDiffer<Node> {
    private Introspector introspector = new StandardIntrospector();

    BeanDiffer() {
        this.setDelegate(new DelegatingObjectDifferImpl(this, null, null, null));
    }

    BeanDiffer(DelegatingObjectDiffer delegate) {
        super(delegate);
    }

    Node compare(Object working, Object base) {
        Assert.notNull(working, "working");
        Assert.equalTypesOrNull(working, base);
        return this.compare(Node.ROOT, Instances.of(new RootAccessor(), working, base));
    }

    @Override
    protected Node internalCompare(Node parentNode, Instances instances) {
        Node node = this.newNode(parentNode, instances);
        if (this.getDelegate().isIgnored(node)) {
            node.setState(Node.State.IGNORED);
        } else if (instances.areNull()) {
            node.setState(Node.State.UNTOUCHED);
        } else {
            return this.compareBean(parentNode, instances);
        }
        return node;
    }

    @Override
    protected Node newNode(Node parentNode, Instances instances) {
        return new DefaultNode(parentNode, instances.getSourceAccessor(), instances.getType());
    }

    private Node compareBean(Node parentNode, Instances instances) {
        Node node = this.newNode(parentNode, instances);
        if (instances.hasBeenAdded()) {
            BeanDiffer.ensureNodeState(node, Node.State.ADDED);
            this.compareBeanUsingAppropriateMethod(node, instances);
            BeanDiffer.ensureNodeState(node, Node.State.ADDED);
        } else if (instances.hasBeenRemoved()) {
            BeanDiffer.ensureNodeState(node, Node.State.REMOVED);
            this.compareBeanUsingAppropriateMethod(node, instances);
            BeanDiffer.ensureNodeState(node, Node.State.REMOVED);
        } else if (instances.areSame()) {
            BeanDiffer.ensureNodeState(node, Node.State.UNTOUCHED);
        } else {
            this.compareBeanUsingAppropriateMethod(node, instances);
        }
        return node;
    }

    private static void ensureNodeState(Node node, Node.State state) {
        node.setState(state);
    }

    private void compareBeanUsingAppropriateMethod(Node node, Instances instances) {
        if (this.getDelegate().isIntrospectible(node)) {
            this.compareProperties(node, instances);
        } else if (this.getDelegate().isEqualsOnly(node)) {
            this.compareEquality(node, instances);
        }
    }

    private void compareEquality(Node node, Instances instances) {
        if (!instances.areEqual()) {
            BeanDiffer.ensureNodeState(node, Node.State.CHANGED);
        }
    }

    private void compareProperties(Node parentNode, Instances instances) {
        DelegatingObjectDiffer delegate = this.getDelegate();
        for (Accessor accessor : this.introspect(instances.getType())) {
            Node propertyNode = new DefaultNode(parentNode, accessor, null);
            if (delegate.isIgnored(propertyNode)) {
                propertyNode.setState(Node.State.IGNORED);
            } else {
                propertyNode = delegate.delegate(parentNode, instances.access(accessor));
            }
            if (!delegate.isReturnable(propertyNode)) continue;
            parentNode.addChild(propertyNode);
        }
    }

    private Iterable<Accessor> introspect(Class<?> type) {
        Iterable<Accessor> accessorIterable = this.introspector.introspect(type);
        if (accessorIterable != null) {
            return accessorIterable;
        }
        return Collections.emptyList();
    }

    void setIntrospector(Introspector introspector) {
        Assert.notNull(introspector, "introspector");
        this.introspector = introspector;
    }
}

