/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.AbstractDiffer;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.DelegatingObjectDifferImpl;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.accessor.RootAccessor;
import de.danielbechler.diff.node.CollectionNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Collections;
import java.util.ArrayList;
import java.util.Collection;

final class CollectionDiffer
extends AbstractDiffer<CollectionNode> {
    public CollectionDiffer() {
        this.setDelegate(new DelegatingObjectDifferImpl(null, null, this, null));
    }

    public CollectionDiffer(DelegatingObjectDiffer delegate) {
        super(delegate);
    }

    public CollectionNode compare(Collection<?> working, Collection<?> base) {
        return (CollectionNode)this.compare(Node.ROOT, Instances.of(new RootAccessor(), working, base));
    }

    @Override
    protected CollectionNode internalCompare(Node parentNode, Instances instances) {
        CollectionNode node = this.newNode(parentNode, instances);
        if (this.getDelegate().isIgnored(node)) {
            node.setState(Node.State.IGNORED);
        } else if (instances.getWorking() != null && instances.getBase() == null) {
            this.handleItems(node, instances, instances.getWorking(Collection.class));
            node.setState(Node.State.ADDED);
        } else if (instances.getWorking() == null && instances.getBase() != null) {
            this.handleItems(node, instances, instances.getBase(Collection.class));
            node.setState(Node.State.REMOVED);
        } else if (instances.areSame()) {
            node.setState(Node.State.UNTOUCHED);
        } else {
            this.handleItems(node, instances, CollectionDiffer.findAddedItems(instances));
            this.handleItems(node, instances, CollectionDiffer.findRemovedItems(instances));
            this.handleItems(node, instances, CollectionDiffer.findKnownItems(instances));
        }
        return node;
    }

    @Override
    protected CollectionNode newNode(Node parentNode, Instances instances) {
        return new CollectionNode(parentNode, instances.getSourceAccessor(), instances.getType());
    }

    private void handleItems(CollectionNode collectionNode, Instances instances, Iterable<?> items) {
        for (Object item : items) {
            Node child = this.compareItem(collectionNode, instances, item);
            if (!this.getDelegate().isReturnable(child)) continue;
            collectionNode.addChild(child);
        }
    }

    private Node compareItem(CollectionNode collectionNode, Instances instances, Object item) {
        return this.getDelegate().delegate(collectionNode, instances.access(collectionNode.accessorForItem(item)));
    }

    private static Collection<?> findAddedItems(Instances instances) {
        return Collections.filteredCopyOf(instances.getWorking(Collection.class), instances.getBase(Collection.class));
    }

    private static Collection<?> findRemovedItems(Instances instances) {
        return Collections.filteredCopyOf(instances.getBase(Collection.class), instances.getWorking(Collection.class));
    }

    private static Iterable<?> findKnownItems(Instances instances) {
        ArrayList changed = new ArrayList(instances.getWorking(Collection.class));
        changed.removeAll(CollectionDiffer.findAddedItems(instances));
        changed.removeAll(CollectionDiffer.findRemovedItems(instances));
        return changed;
    }
}

