/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.BeanDiffer;
import de.danielbechler.diff.CollectionDiffer;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.MapDiffer;
import de.danielbechler.diff.PrimitiveDiffer;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import java.util.Collection;
import java.util.Map;

final class DelegatingObjectDifferImpl
implements DelegatingObjectDiffer {
    private final Differ beanDiffer;
    private final Differ mapDiffer;
    private final Differ collectionDiffer;
    private final Differ primitiveDiffer;
    private Configuration configuration = new Configuration();

    public DelegatingObjectDifferImpl() {
        this.beanDiffer = new BeanDiffer(this);
        this.mapDiffer = new MapDiffer(this);
        this.collectionDiffer = new CollectionDiffer(this);
        this.primitiveDiffer = new PrimitiveDiffer(this);
    }

    public DelegatingObjectDifferImpl(Differ beanDiffer, Differ mapDiffer, Differ collectionDiffer, Differ primitiveDiffer) {
        this.beanDiffer = beanDiffer != null ? beanDiffer : new BeanDiffer(this);
        this.mapDiffer = mapDiffer != null ? mapDiffer : new MapDiffer(this);
        this.collectionDiffer = collectionDiffer != null ? collectionDiffer : new CollectionDiffer(this);
        this.primitiveDiffer = primitiveDiffer != null ? primitiveDiffer : new PrimitiveDiffer(this);
    }

    @Override
    public <T> Node compare(T working, T base) {
        return this.delegate(Node.ROOT, Instances.of(working, base));
    }

    @Override
    public Node delegate(Node parentNode, Instances instances) {
        Assert.notNull(instances, "instances");
        if (instances.areNull()) {
            return DelegatingObjectDifferImpl.newNode(parentNode, instances);
        }
        if (instances.isPrimitiveType()) {
            return this.primitiveDiffer.compare(parentNode, instances);
        }
        if (Collection.class.isAssignableFrom(instances.getType())) {
            return this.collectionDiffer.compare(parentNode, instances);
        }
        if (Map.class.isAssignableFrom(instances.getType())) {
            return this.mapDiffer.compare(parentNode, instances);
        }
        return this.beanDiffer.compare(parentNode, instances);
    }

    private static Node newNode(Node parentNode, Instances instances) {
        return new DefaultNode(parentNode, instances.getSourceAccessor(), instances.getType());
    }

    @Override
    public boolean isIgnored(Node node) {
        return this.configuration.isIgnored(node);
    }

    @Override
    public boolean isIncluded(Node node) {
        return this.configuration.isIncluded(node);
    }

    @Override
    public boolean isExcluded(Node node) {
        return this.configuration.isExcluded(node);
    }

    @Override
    public boolean isEqualsOnly(Node node) {
        return this.configuration.isEqualsOnly(node);
    }

    @Override
    public boolean isReturnable(Node node) {
        return this.configuration.isReturnable(node);
    }

    @Override
    public boolean isIntrospectible(Node node) {
        return this.configuration.isIntrospectible(node);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        Assert.notNull(configuration, "configuration");
        this.configuration = configuration;
    }

    Differ getBeanDiffer() {
        return this.beanDiffer;
    }

    Differ getMapDiffer() {
        return this.mapDiffer;
    }

    Differ getCollectionDiffer() {
        return this.collectionDiffer;
    }
}

