/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.AbstractDiffer;
import de.danielbechler.diff.DelegatingObjectDiffer;
import de.danielbechler.diff.DelegatingObjectDifferImpl;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.accessor.RootAccessor;
import de.danielbechler.diff.node.MapNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Collections;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

final class MapDiffer
extends AbstractDiffer<MapNode> {
    public MapDiffer() {
        this.setDelegate(new DelegatingObjectDifferImpl(null, this, null, null));
    }

    public MapDiffer(DelegatingObjectDiffer delegate) {
        super(delegate);
    }

    public MapNode compare(Map<?, ?> modified, Map<?, ?> base) {
        return (MapNode)this.compare(Node.ROOT, Instances.of(new RootAccessor(), modified, base));
    }

    @Override
    protected MapNode internalCompare(Node parentNode, Instances instances) {
        MapNode node = this.newNode(parentNode, instances);
        if (this.getConfiguration().isIgnored(node)) {
            node.setState(Node.State.IGNORED);
            return node;
        }
        MapDiffer.indexAll(instances, node);
        if (instances.getWorking() != null && instances.getBase() == null) {
            this.handleEntries(instances, node, instances.getWorking(Map.class).keySet());
            node.setState(Node.State.ADDED);
        } else if (instances.getWorking() == null && instances.getBase() != null) {
            this.handleEntries(instances, node, instances.getBase(Map.class).keySet());
            node.setState(Node.State.REMOVED);
        } else if (instances.areSame()) {
            node.setState(Node.State.UNTOUCHED);
        } else {
            this.handleEntries(instances, node, MapDiffer.findAddedKeys(instances));
            this.handleEntries(instances, node, MapDiffer.findRemovedKeys(instances));
            this.handleEntries(instances, node, MapDiffer.findKnownKeys(instances));
        }
        return node;
    }

    @Override
    protected MapNode newNode(Node parentNode, Instances instances) {
        return new MapNode(parentNode, instances.getSourceAccessor(), instances.getType());
    }

    private static void indexAll(Instances instances, MapNode node) {
        node.indexKeys(instances.getWorking(Map.class), instances.getBase(Map.class), instances.getFresh(Map.class));
    }

    private void handleEntries(Instances instances, MapNode parent, Iterable<?> keys) {
        for (Object key : keys) {
            this.handleEntries(key, instances, parent);
        }
    }

    private void handleEntries(Object key, Instances instances, MapNode parent) {
        Node node = this.compareEntry(key, instances, parent);
        if (this.getDelegate().isReturnable(node)) {
            parent.addChild(node);
        }
    }

    private Node compareEntry(Object key, Instances instances, MapNode parent) {
        return this.getDelegate().delegate(parent, instances.access(parent.accessorForKey(key)));
    }

    private static Collection<?> findAddedKeys(Instances instances) {
        Set source = instances.getWorking(Map.class).keySet();
        Set filter = instances.getBase(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Collection<?> findRemovedKeys(Instances instances) {
        Set source = instances.getBase(Map.class).keySet();
        Set filter = instances.getWorking(Map.class).keySet();
        return Collections.filteredCopyOf(source, filter);
    }

    private static Iterable<?> findKnownKeys(Instances instances) {
        Set keys = instances.getWorking(Map.class).keySet();
        Set changed = Collections.setOf(keys);
        changed.removeAll(MapDiffer.findAddedKeys(instances));
        changed.removeAll(MapDiffer.findRemovedKeys(instances));
        return changed;
    }
}

