/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.accessor;

import de.danielbechler.diff.accessor.AbstractAccessor;
import de.danielbechler.diff.path.Element;
import de.danielbechler.diff.path.MapElement;
import de.danielbechler.util.Assert;
import java.util.List;
import java.util.Map;

public final class MapEntryAccessor
extends AbstractAccessor {
    private final List<?> referenceKeys;
    private final int index;

    public MapEntryAccessor(List<?> referenceKeys, int index) {
        Assert.notNull(referenceKeys, "referenceKeys");
        if (index < 0 || index > referenceKeys.size() - 1) {
            throw new IndexOutOfBoundsException("Index " + index + " is not within the valid range of the given List");
        }
        this.referenceKeys = referenceKeys;
        this.index = index;
    }

    @Override
    public Element getPathElement() {
        return new MapElement(this.getReferenceKey());
    }

    @Override
    public void set(Object target, Object value) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            targetMap.put(this.getReferenceKey(), value);
        }
    }

    @Override
    public Object get(Object target) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            return targetMap.get(this.getReferenceKey());
        }
        return null;
    }

    private static Map<Object, Object> objectToMap(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Map) {
            return (Map)object;
        }
        throw new IllegalArgumentException(object.getClass().toString());
    }

    private Object getReferenceKey() {
        return this.referenceKeys.get(this.index);
    }

    @Override
    public void unset(Object target) {
        Map<Object, Object> targetMap = MapEntryAccessor.objectToMap(target);
        if (targetMap != null) {
            targetMap.remove(this.getReferenceKey());
        }
    }

    public String toString() {
        return "map key " + this.getPathElement();
    }
}

