/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import java.util.Deque;
import java.util.LinkedList;

final class CircularReferenceDetector {
    private final Deque<Object> stack = new LinkedList<Object>();
    private boolean isNew = true;

    @Deprecated
    public boolean isNew() {
        return this.isNew;
    }

    public void push(Object instance) {
        if (instance == null) {
            return;
        }
        if (this.isNew) {
            this.isNew = false;
        }
        if (this.knows(instance)) {
            throw new CircularReferenceException();
        }
        this.stack.addLast(instance);
    }

    public boolean knows(Object needle) {
        for (Object object : this.stack) {
            if (object != needle) continue;
            return true;
        }
        return false;
    }

    public void remove(Object instance) {
        if (instance == null) {
            return;
        }
        if (this.stack.getLast() != instance) {
            throw new IllegalArgumentException("Detected inconsistency in enter/leave sequence. Must always be LIFO.");
        }
        this.stack.removeLast();
    }

    public int size() {
        return this.stack.size();
    }

    public static class CircularReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

