/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.CollectionItemAccessorFactory;
import de.danielbechler.diff.CollectionNodeFactory;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.NodeInspector;
import de.danielbechler.diff.TestOnly;
import de.danielbechler.diff.accessor.CollectionItemAccessor;
import de.danielbechler.diff.node.CollectionNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Collections;
import java.util.ArrayList;
import java.util.Collection;

final class CollectionDiffer
implements Differ<CollectionNode> {
    private final DifferDelegator delegator;
    private final NodeInspector nodeInspector;
    private CollectionNodeFactory collectionNodeFactory = new CollectionNodeFactory();
    private CollectionItemAccessorFactory collectionItemAccessorFactory = new CollectionItemAccessorFactory();

    public CollectionDiffer(DifferDelegator delegator, NodeInspector nodeInspector) {
        Assert.notNull(delegator, "delegator");
        Assert.notNull(nodeInspector, "nodeInspector");
        this.delegator = delegator;
        this.nodeInspector = nodeInspector;
    }

    @Override
    public final CollectionNode compare(Node parentNode, Instances collectionInstances) {
        CollectionNode collectionNode = this.collectionNodeFactory.create(parentNode, collectionInstances);
        if (this.nodeInspector.isIgnored(collectionNode)) {
            collectionNode.setState(Node.State.IGNORED);
        } else if (this.nodeInspector.isEqualsOnly(collectionNode)) {
            if (collectionInstances.areEqual()) {
                collectionNode.setState(Node.State.UNTOUCHED);
            } else {
                collectionNode.setState(Node.State.CHANGED);
            }
        } else if (collectionInstances.hasBeenAdded()) {
            this.compareItems(collectionNode, collectionInstances, collectionInstances.getWorking(Collection.class));
            collectionNode.setState(Node.State.ADDED);
        } else if (collectionInstances.hasBeenRemoved()) {
            this.compareItems(collectionNode, collectionInstances, collectionInstances.getBase(Collection.class));
            collectionNode.setState(Node.State.REMOVED);
        } else if (collectionInstances.areSame()) {
            collectionNode.setState(Node.State.UNTOUCHED);
        } else {
            this.compareItems(collectionNode, collectionInstances, CollectionDiffer.addedItemsOf(collectionInstances));
            this.compareItems(collectionNode, collectionInstances, CollectionDiffer.removedItemsOf(collectionInstances));
            this.compareItems(collectionNode, collectionInstances, CollectionDiffer.knownItemsOf(collectionInstances));
        }
        return collectionNode;
    }

    private void compareItems(Node collectionNode, Instances instances, Iterable<?> items) {
        for (Object item : items) {
            Node child = this.compareItem(collectionNode, instances, item);
            if (!this.nodeInspector.isReturnable(child)) continue;
            collectionNode.addChild(child);
        }
    }

    private Node compareItem(Node collectionNode, Instances collectionInstances, Object collectionItem) {
        CollectionItemAccessor itemAccessor = this.collectionItemAccessorFactory.createAccessorForItem(collectionItem);
        Instances itemInstances = collectionInstances.access(itemAccessor);
        return this.delegator.delegate(collectionNode, itemInstances);
    }

    private static Collection<?> addedItemsOf(Instances instances) {
        return Collections.filteredCopyOf(instances.getWorking(Collection.class), instances.getBase(Collection.class));
    }

    private static Collection<?> removedItemsOf(Instances instances) {
        return Collections.filteredCopyOf(instances.getBase(Collection.class), instances.getWorking(Collection.class));
    }

    private static Iterable<?> knownItemsOf(Instances instances) {
        ArrayList changed = new ArrayList(instances.getWorking(Collection.class));
        changed.removeAll(CollectionDiffer.addedItemsOf(instances));
        changed.removeAll(CollectionDiffer.removedItemsOf(instances));
        return changed;
    }

    @TestOnly
    void setCollectionNodeFactory(CollectionNodeFactory collectionNodeFactory) {
        this.collectionNodeFactory = collectionNodeFactory;
    }

    @TestOnly
    void setCollectionItemAccessorFactory(CollectionItemAccessorFactory collectionItemAccessorFactory) {
        this.collectionItemAccessorFactory = collectionItemAccessorFactory;
    }
}

