/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.BeanDiffer;
import de.danielbechler.diff.CollectionDiffer;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.Differ;
import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.MapDiffer;
import de.danielbechler.diff.PrimitiveDiffer;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Classes;
import java.util.Collection;
import java.util.Map;

public class DifferFactory {
    private final Configuration configuration;

    public DifferFactory(Configuration configuration) {
        Assert.notNull(configuration, "configuration");
        this.configuration = configuration;
    }

    public Differ<?> createDiffer(Class<?> type, DifferDelegator delegator) {
        Assert.notNull(delegator, "delegator");
        if (Classes.isPrimitiveType(type)) {
            return new PrimitiveDiffer(this.configuration);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return new CollectionDiffer(delegator, this.configuration);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapDiffer(delegator, this.configuration);
        }
        return new BeanDiffer(delegator, this.configuration);
    }
}

