/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.visitor;

import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.visitor.AbstractFilteringVisitor;
import de.danielbechler.diff.visitor.Visit;
import de.danielbechler.util.Collections;
import java.util.Collection;
import java.util.TreeSet;

public abstract class CategoryFilteringVisitor
extends AbstractFilteringVisitor {
    private final Collection<String> include = new TreeSet<String>();
    private final Collection<String> exclude = new TreeSet<String>();
    private boolean includeAllNonExcluded;

    @Override
    protected boolean accept(Node node) {
        if (this.isExcluded(node)) {
            return false;
        }
        return this.isIncluded(node) || this.includeAllNonExcluded;
    }

    @Override
    protected void onDismiss(Node node, Visit visit) {
        super.onDismiss(node, visit);
        visit.dontGoDeeper();
    }

    private boolean isExcluded(Node node) {
        return Collections.containsAny(node.getCategories(), this.exclude);
    }

    private boolean isIncluded(Node node) {
        return Collections.containsAny(node.getCategories(), this.include);
    }

    public final CategoryFilteringVisitor include(String category) {
        this.include.add(category);
        this.exclude.remove(category);
        return this;
    }

    public final CategoryFilteringVisitor includeOnly(String category) {
        this.include(category);
        this.includeAllNonExcluded(false);
        return this;
    }

    public final CategoryFilteringVisitor includeAllNonExcluded(boolean value) {
        this.includeAllNonExcluded = value;
        return this;
    }

    public final CategoryFilteringVisitor exclude(String category) {
        this.exclude.add(category);
        this.include.remove(category);
        return this;
    }
}

