/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.util;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Strings {
    private static final Pattern LINE_BREAK_PATTERN = Pattern.compile("\\s*\\n\\s*");

    private Strings() {
    }

    public static boolean hasText(String s) {
        return s != null && s.trim().length() > 0;
    }

    public static boolean isEmpty(String s) {
        return !Strings.hasText(s);
    }

    public static String capitalize(String s) {
        if (s != null && s.length() > 0) {
            char[] chars = s.toCharArray();
            chars[0] = Character.toUpperCase(chars[0]);
            return new String(chars).intern();
        }
        return s;
    }

    public static String toPropertyExpression(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        char previousChar = ' ';
        for (char aChar : chars) {
            if (aChar != '_') {
                if (previousChar == '_') {
                    sb.append(Character.toUpperCase(aChar));
                } else {
                    sb.append(Character.toLowerCase(aChar));
                }
            }
            previousChar = aChar;
        }
        return sb.toString();
    }

    public static String toUnderscoreCase(String s) {
        char[] chars = s.toCharArray();
        StringBuilder sb = new StringBuilder();
        char previousChar = '\u0000';
        for (char aChar : chars) {
            if (Character.isUpperCase(aChar)) {
                if (previousChar != '\u0000') {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(aChar));
            } else {
                sb.append(aChar);
            }
            previousChar = aChar;
        }
        return sb.toString();
    }

    public static String join(String delimiter, Object ... elements) {
        StringBuilder sb = new StringBuilder();
        for (Object part : elements) {
            if (part == null) continue;
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(part.toString());
        }
        return sb.toString();
    }

    public static String join(String delimiter, Collection<?> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        return Strings.join(delimiter, elements.toArray(new Object[elements.size()]));
    }

    public static String toSingleLineString(Object object) {
        if (object != null) {
            String s = object.toString().trim();
            Matcher matcher = LINE_BREAK_PATTERN.matcher(s);
            return matcher.replaceAll(" \\\\ ");
        }
        return null;
    }

    public static String indent(int times, String text) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append("  ");
        }
        sb.append(text);
        return sb.toString();
    }
}

