/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.util.Assert;
import java.util.LinkedList;

class CircularReferenceDetector {
    private final LinkedList<Entry> stack = new LinkedList();
    private ReferenceMatchingMode referenceMatchingMode = ReferenceMatchingMode.EQUALITY_OPERATOR;

    public void push(Object instance, PropertyPath propertyPath) {
        if (instance == null) {
            return;
        }
        if (this.knows(instance)) {
            throw new CircularReferenceException(this.entryForInstance(instance).getPropertyPath());
        }
        Entry entry = new Entry(propertyPath, instance);
        this.stack.addLast(entry);
    }

    public boolean knows(Object needle) {
        for (Entry entry : this.stack) {
            Object instance = entry.getInstance();
            if (!this.isMatch(needle, instance)) continue;
            return true;
        }
        return false;
    }

    protected boolean isMatch(Object anObject, Object anotherObject) {
        if (this.referenceMatchingMode == ReferenceMatchingMode.EQUALS_METHOD) {
            return anotherObject != null && anObject != null && anotherObject.equals(anObject);
        }
        if (this.referenceMatchingMode == ReferenceMatchingMode.EQUALITY_OPERATOR) {
            return anotherObject == anObject;
        }
        throw new IllegalStateException("Missing reference matching mode");
    }

    private Entry entryForInstance(Object instance) {
        for (Entry entry : this.stack) {
            if (!this.isMatch(instance, entry.getInstance())) continue;
            return entry;
        }
        return null;
    }

    public void remove(Object instance) {
        if (instance == null) {
            return;
        }
        if (!this.isMatch(instance, this.stack.getLast().getInstance())) {
            throw new IllegalArgumentException("Detected inconsistency in enter/leave sequence. Must always be LIFO.");
        }
        this.stack.removeLast();
    }

    public int size() {
        return this.stack.size();
    }

    public void setReferenceMatchingMode(ReferenceMatchingMode referenceMatchingMode) {
        Assert.notNull((Object)referenceMatchingMode, "referenceMatchingMode");
        this.referenceMatchingMode = referenceMatchingMode;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ReferenceMatchingMode {
        EQUALITY_OPERATOR,
        EQUALS_METHOD;

    }

    public static class CircularReferenceException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        private final PropertyPath propertyPath;

        public CircularReferenceException(PropertyPath propertyPath) {
            this.propertyPath = propertyPath;
        }

        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }

        public Throwable fillInStackTrace() {
            return null;
        }
    }

    private static class Entry {
        private final PropertyPath propertyPath;
        private final Object instance;

        private Entry(PropertyPath propertyPath, Object instance) {
            this.propertyPath = propertyPath;
            this.instance = instance;
        }

        public PropertyPath getPropertyPath() {
            return this.propertyPath;
        }

        public Object getInstance() {
            return this.instance;
        }
    }
}

