/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.accessor.PropertyAccessor;
import de.danielbechler.diff.accessor.RootAccessor;
import de.danielbechler.diff.accessor.TypeAwareAccessor;
import de.danielbechler.diff.node.CollectionNode;
import de.danielbechler.diff.node.MapNode;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.Element;
import de.danielbechler.diff.path.NamedPropertyElement;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.visitor.PropertyVisitor;
import de.danielbechler.diff.visitor.StopVisitationException;
import de.danielbechler.diff.visitor.Visit;
import de.danielbechler.util.Assert;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNode
implements Node {
    private final Accessor accessor;
    private final Map<Element, Node> children = new LinkedHashMap<Element, Node>(10);
    private Node.State state = Node.State.UNTOUCHED;
    private Node parentNode;
    private PropertyPath circleStartPath;
    private Node circleStartNode;
    private Class<?> valueType;

    public DefaultNode(Node parentNode, Accessor accessor, Class<?> valueType) {
        Assert.notNull(accessor, "accessor");
        this.accessor = accessor;
        this.valueType = valueType;
        this.setParentNode(parentNode);
    }

    public DefaultNode(Accessor accessor, Class<?> valueType) {
        this(Node.ROOT, accessor, valueType);
    }

    public DefaultNode(Class<?> valueType) {
        this(Node.ROOT, RootAccessor.getInstance(), valueType);
    }

    @Override
    public Node.State getState() {
        return this.state;
    }

    @Override
    public boolean matches(PropertyPath path) {
        return path.matches(this.getPropertyPath());
    }

    @Override
    public boolean hasChanges() {
        if (this.isAdded() || this.isChanged() || this.isRemoved()) {
            return true;
        }
        final AtomicBoolean result = new AtomicBoolean(false);
        this.visitChildren(new Node.Visitor(){

            public void accept(Node node, Visit visit) {
                if (node.hasChanges()) {
                    result.set(true);
                    visit.stop();
                }
            }
        });
        return result.get();
    }

    @Override
    public final boolean isAdded() {
        return this.state == Node.State.ADDED;
    }

    @Override
    public final boolean isChanged() {
        return this.state == Node.State.CHANGED;
    }

    @Override
    public final boolean isRemoved() {
        return this.state == Node.State.REMOVED;
    }

    @Override
    public final boolean isUntouched() {
        return this.state == Node.State.UNTOUCHED;
    }

    @Override
    public boolean isCircular() {
        return this.state == Node.State.CIRCULAR;
    }

    @Override
    public final PropertyPath getPropertyPath() {
        if (this.parentNode != null) {
            return PropertyPath.createBuilder().withPropertyPath(this.parentNode.getPropertyPath()).withElement(this.accessor.getPathElement()).build();
        }
        if (this.accessor instanceof RootAccessor) {
            return PropertyPath.createBuilder().withRoot().build();
        }
        return PropertyPath.createBuilder().withRoot().withElement(this.accessor.getPathElement()).build();
    }

    @Override
    public Element getPathElement() {
        return this.accessor.getPathElement();
    }

    @Override
    public boolean isCollectionNode() {
        return false;
    }

    @Override
    public CollectionNode toCollectionNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isMapNode() {
        return false;
    }

    @Override
    public MapNode toMapNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class<?> getType() {
        if (this.accessor instanceof TypeAwareAccessor) {
            return ((TypeAwareAccessor)this.accessor).getType();
        }
        return this.valueType;
    }

    @Override
    public void setType(Class<?> aClass) {
        this.valueType = aClass;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public Collection<Node> getChildren() {
        return this.children.values();
    }

    @Override
    public Node getChild(String propertyName) {
        return this.children.get(new NamedPropertyElement(propertyName));
    }

    @Override
    public Node getChild(PropertyPath path) {
        PropertyVisitor visitor = new PropertyVisitor(path);
        this.visitChildren(visitor);
        return visitor.getNode();
    }

    @Override
    public Node getChild(Element pathElement) {
        return this.children.get(pathElement);
    }

    @Override
    public boolean addChild(Node node) {
        if (node.isRootNode()) {
            throw new IllegalArgumentException("Detected attempt to add root node as child. This is not allowed and must be a mistake.");
        }
        if (node == this) {
            throw new IllegalArgumentException("Detected attempt to add a node to itself. This would cause inifite loops and must never happen.");
        }
        if (node.getParentNode() != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("Detected attempt to add child node that is already the child of another node. Adding nodes multiple times is not allowed, since it could cause infinite loops.");
        }
        Element pathElement = node.getPathElement();
        if (node.getParentNode() == null) {
            node.setParentNode(this);
            this.children.put(pathElement, node);
        } else if (node.getParentNode() == this) {
            this.children.put(pathElement, node);
        } else {
            throw new IllegalStateException("Detected attempt to replace the parent node of node at path '" + this.getPropertyPath() + "'");
        }
        if (this.state == Node.State.UNTOUCHED && node.hasChanges()) {
            this.state = Node.State.CHANGED;
        }
        return true;
    }

    @Override
    public final void visit(Node.Visitor visitor) {
        Visit visit = new Visit();
        try {
            this.visit(visitor, visit);
        }
        catch (StopVisitationException stopVisitationException) {
            // empty catch block
        }
    }

    protected final void visit(Node.Visitor visitor, Visit visit) {
        try {
            visitor.accept(this, visit);
        }
        catch (StopVisitationException e) {
            visit.stop();
        }
        if (visit.isAllowedToGoDeeper() && this.hasChildren()) {
            this.visitChildren(visitor);
        }
        if (visit.isStopped()) {
            throw new StopVisitationException();
        }
    }

    @Override
    public final void visitChildren(Node.Visitor visitor) {
        for (Node child : this.getChildren()) {
            try {
                child.visit(visitor);
            }
            catch (StopVisitationException e) {
                return;
            }
        }
    }

    @Override
    public Set<Annotation> getPropertyAnnotations() {
        if (this.accessor instanceof PropertyAccessor) {
            return Collections.unmodifiableSet(((PropertyAccessor)this.accessor).getReadMethodAnnotations());
        }
        return Collections.unmodifiableSet(Collections.emptySet());
    }

    @Override
    public <T extends Annotation> T getPropertyAnnotation(Class<T> annotationClass) {
        if (this.accessor instanceof PropertyAccessor) {
            return ((PropertyAccessor)this.accessor).getReadMethodAnnotation(annotationClass);
        }
        return null;
    }

    @Override
    public final boolean isRootNode() {
        return this.accessor instanceof RootAccessor;
    }

    @Override
    public final boolean isEqualsOnly() {
        return this.accessor.isEqualsOnly();
    }

    @Override
    public final boolean isIgnored() {
        return this.state == Node.State.IGNORED || this.accessor.isIgnored();
    }

    @Override
    public final Set<String> getCategories() {
        TreeSet<String> set = new TreeSet<String>();
        if (this.parentNode != null) {
            set.addAll(this.parentNode.getCategories());
        }
        if (this.accessor.getCategories() != null) {
            set.addAll(this.accessor.getCategories());
        }
        return set;
    }

    @Override
    public void setState(Node.State state) {
        Assert.notNull((Object)state, "state");
        this.state = state;
    }

    @Override
    public Node getParentNode() {
        return this.parentNode;
    }

    @Override
    public final void setParentNode(Node parentNode) {
        if (this.parentNode != null && this.parentNode != parentNode) {
            throw new IllegalStateException("The parent of a node cannot be changed, once it's set.");
        }
        this.parentNode = parentNode;
    }

    @Override
    public Object get(Object target) {
        return this.accessor.get(target);
    }

    @Override
    public void set(Object target, Object value) {
        this.accessor.set(target, value);
    }

    @Override
    public void unset(Object target) {
        this.accessor.unset(target);
    }

    @Override
    public Object canonicalGet(Object target) {
        if (this.parentNode != null) {
            target = this.parentNode.canonicalGet(target);
        }
        return this.accessor.get(target);
    }

    @Override
    public void canonicalSet(Object target, Object value) {
        if (this.parentNode != null) {
            target = this.parentNode.canonicalGet(target);
        }
        this.accessor.set(target, value);
    }

    @Override
    public void canonicalUnset(Object target) {
        if (this.parentNode != null) {
            target = this.parentNode.canonicalGet(target);
        }
        this.accessor.unset(target);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("(");
        sb.append("state=");
        sb.append(this.getState().toString());
        if (this.getType() != null) {
            sb.append(", type=").append(this.getType().getCanonicalName());
        }
        if (this.getChildren().size() == 1) {
            sb.append(", ").append(this.getChildren().size()).append(" child");
        } else if (this.getChildren().size() > 1) {
            sb.append(", ").append(this.getChildren().size()).append(" children");
        } else {
            sb.append(", no children");
        }
        if (!this.getCategories().isEmpty()) {
            sb.append(", categorized as ").append(this.getCategories());
        }
        sb.append(", accessed via ").append(this.accessor);
        sb.append(')');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNode that = (DefaultNode)o;
        return this.accessor.equals(that.accessor);
    }

    public int hashCode() {
        return this.accessor.hashCode();
    }

    @Override
    public PropertyPath getCircleStartPath() {
        return this.circleStartPath;
    }

    @Override
    public void setCircleStartPath(PropertyPath circularStartPath) {
        this.circleStartPath = circularStartPath;
    }

    @Override
    public Node getCircleStartNode() {
        return this.circleStartNode;
    }

    @Override
    public void setCircleStartNode(Node circleStartNode) {
        this.circleStartNode = circleStartNode;
    }
}

