/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.CircularReferenceDetector;
import de.danielbechler.diff.CircularReferenceDetectorFactory;
import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.DifferDelegator;
import de.danielbechler.diff.DifferFactory;
import de.danielbechler.diff.Instances;
import de.danielbechler.diff.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectDiffer {
    private static final CircularReferenceDetectorFactory CIRCULAR_REFERENCE_DETECTOR_WITH_EQUALITY_OPERATOR_FACTORY = new CircularReferenceDetectorFactory(){

        public CircularReferenceDetector create() {
            CircularReferenceDetector circularReferenceDetector = new CircularReferenceDetector();
            circularReferenceDetector.setReferenceMatchingMode(CircularReferenceDetector.ReferenceMatchingMode.EQUALITY_OPERATOR);
            return circularReferenceDetector;
        }
    };
    private static final CircularReferenceDetectorFactory CIRCULAR_REFERENCE_DETECTOR_WITH_EQUALS_METHOD_FACTORY = new CircularReferenceDetectorFactory(){

        public CircularReferenceDetector create() {
            CircularReferenceDetector circularReferenceDetector = new CircularReferenceDetector();
            circularReferenceDetector.setReferenceMatchingMode(CircularReferenceDetector.ReferenceMatchingMode.EQUALS_METHOD);
            return circularReferenceDetector;
        }
    };
    private final Configuration configuration;
    private final DifferDelegator delegator;

    ObjectDiffer(Configuration configuration) {
        this.configuration = configuration;
        this.delegator = new DifferDelegator(new DifferFactory(configuration), ObjectDiffer.newCircularReferenceDetectorFactory(configuration));
    }

    public <T> Node compare(T working, T base) {
        return this.delegator.delegate(Node.ROOT, Instances.of(working, base));
    }

    @Deprecated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static CircularReferenceDetectorFactory newCircularReferenceDetectorFactory(Configuration configuration) {
        if (configuration.getCircularReferenceMatchingMode() == Configuration.CircularReferenceMatchingMode.EQUALS_METHOD) {
            return CIRCULAR_REFERENCE_DETECTOR_WITH_EQUALS_METHOD_FACTORY;
        }
        if (configuration.getCircularReferenceMatchingMode() == Configuration.CircularReferenceMatchingMode.EQUALITY_OPERATOR) {
            return CIRCULAR_REFERENCE_DETECTOR_WITH_EQUALITY_OPERATOR_FACTORY;
        }
        throw new IllegalStateException();
    }
}

