/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.node;

import de.danielbechler.diff.accessor.Accessor;
import de.danielbechler.diff.accessor.MapEntryAccessor;
import de.danielbechler.diff.accessor.exception.ItemNotIndexedException;
import de.danielbechler.diff.node.DefaultNode;
import de.danielbechler.diff.node.Node;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapNode
extends DefaultNode {
    private final List<Object> referenceKeys = new LinkedList<Object>();

    public MapNode(Node parentNode, Accessor accessor, Class<?> valueType) {
        super(parentNode, accessor, valueType);
    }

    public int indexKey(Object key) {
        if (this.isIndexed(key)) {
            return this.indexOf(key);
        }
        this.referenceKeys.add(key);
        return this.indexOf(key);
    }

    public Accessor accessorForKey(Object key) {
        if (this.isIndexed(key)) {
            return new MapEntryAccessor(this.referenceKeys, this.indexOf(key));
        }
        throw new ItemNotIndexedException(key);
    }

    private boolean isIndexed(Object key) {
        return this.referenceKeys.contains(key);
    }

    private int indexOf(Object key) {
        return this.referenceKeys.indexOf(key);
    }

    @Override
    public final boolean isMapNode() {
        return true;
    }

    @Override
    public final MapNode toMapNode() {
        return this;
    }
}

