/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.example;

import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.visitor.PrintingVisitor;

class EqualsOnlyValueProviderMethodExample {
    private EqualsOnlyValueProviderMethodExample() {
    }

    public static void main(String[] args) {
        PropertyClass prop = new PropertyClass("1", "2");
        EncompassingClass base = new EncompassingClass(prop);
        PropertyClass prop2 = new PropertyClass("1", "3");
        EncompassingClass working = new EncompassingClass(prop2);
        Configuration configuration = new Configuration();
        configuration.withEqualsOnlyValueProviderMethod(PropertyPath.buildWith("prop", new String[0]), "getProp1");
        Node node = ObjectDifferFactory.getInstance(configuration).compare(working, base);
        node.visit(new PrintingVisitor(working, base));
    }

    public static class EncompassingClass {
        private final PropertyClass prop;

        public EncompassingClass(PropertyClass prop) {
            this.prop = prop;
        }

        public PropertyClass getProp() {
            return this.prop;
        }
    }

    public static class PropertyClass {
        private String prop1;
        private String prop2;

        public PropertyClass(String prop1, String prop2) {
            this.prop1 = prop1;
            this.prop2 = prop2;
        }

        public String getProp1() {
            return this.prop1;
        }

        public String getProp2() {
            return this.prop2;
        }
    }
}

