/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.example;

import de.danielbechler.diff.Configuration;
import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.annotation.ObjectDiffProperty;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.path.PropertyPath;
import de.danielbechler.diff.visitor.PrintingVisitor;

class IgnoreExample {
    private IgnoreExample() {
    }

    public static void main(String[] args) {
        User base = new User("foo", "1234");
        User working = new User("foo", "9876");
        Configuration configuration = new Configuration();
        configuration.withoutProperty(PropertyPath.buildWith("password", new String[0]));
        Node node = ObjectDifferFactory.getInstance(configuration).compare(working, base);
        node.visit(new PrintingVisitor(working, base));
    }

    public static class User {
        private final String name;
        private final String password;

        public User(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        @ObjectDiffProperty(ignore=true)
        public String getPassword() {
            return this.password;
        }
    }
}

