/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.merge;

import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.ObjectDifferFactory;
import de.danielbechler.diff.node.Node;
import de.danielbechler.diff.visitor.Visit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ObjectMerger {
    private final ObjectDiffer objectDiffer;

    public ObjectMerger() {
        this.objectDiffer = ObjectDifferFactory.getInstance();
    }

    public ObjectMerger(ObjectDiffer objectDiffer) {
        this.objectDiffer = objectDiffer;
    }

    public <T> T merge(T modified, T base, T head) {
        MergingDifferenceVisitor<T> visitor = new MergingDifferenceVisitor<T>(head, modified);
        Node difference = this.objectDiffer.compare(modified, base);
        difference.visit(visitor);
        return head;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class MergingDifferenceVisitor<T>
    implements Node.Visitor {
        private final T head;
        private final T modified;

        public MergingDifferenceVisitor(T head, T modified) {
            this.head = head;
            this.modified = modified;
        }

        @Override
        public void accept(Node node, Visit visit) {
            if (node.getState() == Node.State.ADDED) {
                node.canonicalSet(this.head, node.canonicalGet(this.modified));
            } else if (node.getState() == Node.State.REMOVED) {
                node.canonicalUnset(this.head);
            } else if (node.getState() != Node.State.UNTOUCHED && node.getState() == Node.State.CHANGED) {
                if (node.hasChildren()) {
                    node.visitChildren(this);
                    visit.dontGoDeeper();
                } else {
                    node.canonicalSet(this.head, node.canonicalGet(this.modified));
                }
            }
        }
    }
}

