/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.access;

import de.danielbechler.diff.access.Accessor;
import de.danielbechler.diff.access.RootAccessor;
import de.danielbechler.diff.access.TypeAwareAccessor;
import de.danielbechler.util.Assert;
import de.danielbechler.util.Classes;
import de.danielbechler.util.Collections;
import de.danielbechler.util.Objects;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Instances {
    private final Accessor sourceAccessor;
    private final Object working;
    private final Object base;
    private final Object fresh;

    Instances(Accessor sourceAccessor, Object working, Object base, Object fresh) {
        Assert.notNull(sourceAccessor, "sourceAccessor");
        this.sourceAccessor = sourceAccessor;
        this.working = working;
        this.base = base;
        this.fresh = fresh;
    }

    public static <T> Instances of(Accessor sourceAccessor, T working, T base, T fresh) {
        return new Instances(sourceAccessor, working, base, fresh);
    }

    public static <T> Instances of(Accessor sourceAccessor, T working, T base) {
        Object fresh = working != null ? Classes.freshInstanceOf(working.getClass()) : null;
        return new Instances(sourceAccessor, working, base, fresh);
    }

    public static <T> Instances of(T working, T base) {
        Object fresh = working != null ? Classes.freshInstanceOf(working.getClass()) : null;
        return new Instances(RootAccessor.getInstance(), working, base, fresh);
    }

    public Accessor getSourceAccessor() {
        return this.sourceAccessor;
    }

    public Instances access(Accessor accessor) {
        Assert.notNull(accessor, "accessor");
        return new Instances(accessor, accessor.get(this.working), accessor.get(this.base), accessor.get(this.fresh));
    }

    public Object getWorking() {
        return this.working;
    }

    public <T> T getWorking(Class<T> type) {
        return this.working != null ? (T)type.cast(this.working) : null;
    }

    public Object getBase() {
        return this.base;
    }

    public <T> T getBase(Class<T> type) {
        return this.base != null ? (T)type.cast(this.base) : null;
    }

    public Object getFresh() {
        if (this.fresh == null) {
            if (this.isPrimitiveNumericType()) {
                return 0;
            }
            if (this.isPrimitiveBooleanType()) {
                return false;
            }
        }
        return this.fresh;
    }

    public <T> T getFresh(Class<T> type) {
        Object o = this.getFresh();
        return o != null ? (T)type.cast(o) : null;
    }

    public boolean hasBeenAdded() {
        if (this.working != null && this.base == null) {
            return true;
        }
        return this.isPrimitiveType() && Objects.isEqual(this.getFresh(), this.base) && !Objects.isEqual(this.base, this.working);
    }

    public boolean hasBeenRemoved() {
        if (this.base != null && this.working == null) {
            return true;
        }
        return this.isPrimitiveType() && Objects.isEqual(this.getFresh(), this.working) && !Objects.isEqual(this.base, this.working);
    }

    public boolean isPrimitiveType() {
        return Classes.isPrimitiveType(this.getType());
    }

    public boolean isPrimitiveWrapperType() {
        return Classes.isPrimitiveWrapperType(this.getType());
    }

    public Class<?> getType() {
        Set<Class<?>> types = Classes.typesOf(this.working, this.base, this.fresh);
        Class<?> sourceAccessorType = this.tryToGetTypeFromSourceAccessor();
        if (Classes.isPrimitiveType(sourceAccessorType)) {
            return sourceAccessorType;
        }
        if (types.isEmpty()) {
            return null;
        }
        if (types.size() == 1) {
            return Collections.firstElementOf(types);
        }
        if (types.size() > 1) {
            if (Classes.allAssignableFrom(Collection.class, types)) {
                return Collection.class;
            }
            if (Classes.allAssignableFrom(Map.class, types)) {
                return Map.class;
            }
            Class<?> sharedType = Classes.mostSpecificSharedType(types);
            if (sharedType != null) {
                return sharedType;
            }
            if (sourceAccessorType != null) {
                return sourceAccessorType;
            }
        }
        throw new IllegalArgumentException("Detected instances of different types " + types + ". " + "Instances must either be null or have the exact same type.");
    }

    private Class<?> tryToGetTypeFromSourceAccessor() {
        if (this.sourceAccessor instanceof TypeAwareAccessor) {
            return ((TypeAwareAccessor)this.sourceAccessor).getType();
        }
        return null;
    }

    public boolean isPrimitiveNumericType() {
        return Classes.isPrimitiveNumericType(this.getType());
    }

    private boolean isPrimitiveBooleanType() {
        return this.getType() == Boolean.TYPE;
    }

    public boolean areEqual() {
        return Objects.isEqual(this.base, this.working);
    }

    public boolean areSame() {
        return this.working == this.base;
    }

    public boolean areNull() {
        return this.working == null && this.base == null;
    }
}

