/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.ValueNode;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.ElementSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InclusionNode
extends ValueNode<Inclusion> {
    InclusionNode() {
    }

    private InclusionNode(ElementSelector elementSelector, InclusionNode parent) {
        super(elementSelector, parent);
    }

    public boolean isIncluded() {
        if (this.value != Inclusion.EXCLUDED) {
            InclusionNode parentWithInclusion = this.getClosestParentWithValue();
            if (parentWithInclusion != null) {
                return parentWithInclusion.getValue() != Inclusion.EXCLUDED;
            }
            if (this.value == Inclusion.INCLUDED) {
                return true;
            }
            if (this.containsValue(Inclusion.INCLUDED)) {
                return true;
            }
        }
        return false;
    }

    public boolean isExcluded() {
        if (this.value == Inclusion.EXCLUDED) {
            return true;
        }
        return this.parent != null && ((InclusionNode)this.parent).isExcluded();
    }

    public InclusionNode getParent() {
        return (InclusionNode)super.getParent();
    }

    public InclusionNode getNodeForPath(NodePath nodePath) {
        return (InclusionNode)super.getNodeForPath(nodePath);
    }

    public InclusionNode getChild(ElementSelector childSelector) {
        return (InclusionNode)super.getChild(childSelector);
    }

    protected InclusionNode newNode(ElementSelector childSelector) {
        return new InclusionNode(childSelector, this);
    }

    public InclusionNode getClosestParentWithValue() {
        return (InclusionNode)super.getClosestParentWithValue();
    }
}

