/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.inclusion;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.category.CategoryResolver;
import de.danielbechler.diff.inclusion.Inclusion;
import de.danielbechler.diff.inclusion.InclusionConfigurer;
import de.danielbechler.diff.inclusion.InclusionNode;
import de.danielbechler.diff.inclusion.IsIgnoredResolver;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.node.Visit;
import de.danielbechler.diff.path.NodePath;
import de.danielbechler.diff.selector.BeanPropertyElementSelector;
import de.danielbechler.diff.selector.ElementSelector;
import de.danielbechler.util.Assert;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class InclusionService
implements InclusionConfigurer,
IsIgnoredResolver {
    private final CategoryResolver categoryResolver;
    private final ObjectDifferBuilder rootConfiguration;
    private final InclusionNode nodeInclusions = new InclusionNode();
    private final Map<Class<?>, Inclusion> typeInclusions = new HashMap();
    private final Map<String, Inclusion> categoryInclusions = new HashMap<String, Inclusion>();
    private final Map<String, Inclusion> propertyNameInclusions = new HashMap<String, Inclusion>();
    private final InclusionConfigurer.ToInclude includeAndReturn = new ToIncludeAndReturnImpl();
    private final InclusionConfigurer.ToExclude excludeAndReturn = new ToExcludeAndReturnImpl();

    public InclusionService(CategoryResolver categoryResolver, ObjectDifferBuilder rootConfiguration) {
        Assert.notNull(categoryResolver, "categoryResolver");
        Assert.notNull(rootConfiguration, "rootConfiguration");
        this.categoryResolver = categoryResolver;
        this.rootConfiguration = rootConfiguration;
    }

    public boolean isIgnored(DiffNode node) {
        return node.isExcluded() || !this.isIncluded(node) || this.isExcluded(node);
    }

    private boolean isIncluded(DiffNode node) {
        if (this.hasInclusions(Inclusion.INCLUDED)) {
            if (node.isRootNode()) {
                return true;
            }
            if (this.isIncludedByPath(node)) {
                return true;
            }
            if (this.isIncludedByCategory(node)) {
                return true;
            }
            if (this.isIncludedByType(node)) {
                return true;
            }
            return this.isIncludedByPropertyName(node);
        }
        return true;
    }

    private boolean isExcluded(DiffNode node) {
        if (this.hasInclusions(Inclusion.EXCLUDED)) {
            if (node.isExcluded()) {
                return true;
            }
            if (this.isExcludedByPath(node)) {
                return true;
            }
            if (this.isExcludedByCategory(node)) {
                return true;
            }
            if (this.isExcludedByType(node)) {
                return true;
            }
            if (this.isExcludedByPropertyName(node)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasInclusions(Inclusion inclusion) {
        if (this.nodeInclusions.containsValue(inclusion)) {
            return true;
        }
        if (this.typeInclusions.containsValue((Object)inclusion)) {
            return true;
        }
        if (this.categoryInclusions.containsValue((Object)inclusion)) {
            return true;
        }
        return this.propertyNameInclusions.containsValue((Object)inclusion);
    }

    private boolean isIncludedByPath(DiffNode node) {
        return this.nodeInclusions.getNodeForPath(node.getPath()).isIncluded();
    }

    private boolean isIncludedByCategory(DiffNode node) {
        return this.hasCategoryWithInclusion(node, Inclusion.INCLUDED);
    }

    private boolean isIncludedByType(DiffNode node) {
        final AtomicBoolean result = new AtomicBoolean(false);
        node.visitParents(new DiffNode.Visitor(){

            public void node(DiffNode node, Visit visit) {
                if (node.getValueType() != null && InclusionService.this.typeInclusions.get(node.getValueType()) == Inclusion.INCLUDED) {
                    result.set(true);
                    visit.stop();
                }
            }
        });
        if (node.getValueType() != null && this.typeInclusions.get(node.getValueType()) == Inclusion.INCLUDED) {
            result.set(true);
        }
        return result.get();
    }

    private boolean isIncludedByPropertyName(DiffNode node) {
        if (this.isIncludedByOwnPropertyName(node)) {
            return true;
        }
        return this.isIncludedByParentPropertyName(node);
    }

    private boolean isExcludedByPath(DiffNode node) {
        InclusionNode valueNode = this.nodeInclusions.getNodeForPath(node.getPath());
        return valueNode.isExcluded() && !valueNode.containsValue(Inclusion.INCLUDED);
    }

    private boolean isExcludedByCategory(DiffNode node) {
        return this.hasCategoryWithInclusion(node, Inclusion.EXCLUDED);
    }

    private boolean isExcludedByType(DiffNode node) {
        if (node.getValueType() != null) {
            return this.typeInclusions.get(node.getValueType()) == Inclusion.EXCLUDED;
        }
        return false;
    }

    private boolean isExcludedByPropertyName(DiffNode node) {
        String propertyName = node.getPropertyName();
        if (propertyName != null) {
            return this.propertyNameInclusions.get(propertyName) == Inclusion.EXCLUDED;
        }
        return false;
    }

    private boolean hasCategoryWithInclusion(DiffNode node, Inclusion inclusion) {
        for (String category : this.categoryResolver.resolveCategories(node)) {
            if (this.categoryInclusions.get(category) != inclusion) continue;
            return true;
        }
        return false;
    }

    private boolean isIncludedByOwnPropertyName(DiffNode node) {
        String propertyName = node.getPropertyName();
        if (propertyName != null) {
            return this.propertyNameInclusions.get(propertyName) == Inclusion.INCLUDED;
        }
        return false;
    }

    private boolean isIncludedByParentPropertyName(DiffNode node) {
        List<ElementSelector> pathElementSelectors = node.getPath().getElementSelectors();
        for (ElementSelector elementSelector : pathElementSelectors) {
            BeanPropertyElementSelector beanPropertyElement;
            String propertyName;
            if (!(elementSelector instanceof BeanPropertyElementSelector) || (propertyName = (beanPropertyElement = (BeanPropertyElementSelector)elementSelector).getPropertyName()) == null || this.propertyNameInclusions.get(propertyName) != Inclusion.INCLUDED) continue;
            return true;
        }
        return false;
    }

    public InclusionConfigurer.ToInclude include() {
        return this.includeAndReturn;
    }

    public InclusionConfigurer.ToExclude exclude() {
        return this.excludeAndReturn;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToExcludeAndReturnImpl
    implements InclusionConfigurer.ToExcludeAndReturn {
        private ToExcludeAndReturnImpl() {
        }

        @Override
        public ObjectDifferBuilder and() {
            return InclusionService.this.rootConfiguration;
        }

        @Override
        public InclusionConfigurer.ToExcludeAndReturn category(String category) {
            InclusionService.this.categoryInclusions.put(category, Inclusion.EXCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToExcludeAndReturn type(Class<?> type) {
            InclusionService.this.typeInclusions.put(type, Inclusion.EXCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToExcludeAndReturn node(NodePath nodePath) {
            InclusionService.this.nodeInclusions.getNodeForPath(nodePath).setValue(Inclusion.EXCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToExcludeAndReturn propertyName(String propertyName) {
            InclusionService.this.propertyNameInclusions.put(propertyName, Inclusion.EXCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToInclude include() {
            return InclusionService.this.include();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ToIncludeAndReturnImpl
    implements InclusionConfigurer.ToIncludeAndReturn {
        private ToIncludeAndReturnImpl() {
        }

        @Override
        public ObjectDifferBuilder and() {
            return InclusionService.this.rootConfiguration;
        }

        @Override
        public InclusionConfigurer.ToIncludeAndReturn category(String category) {
            InclusionService.this.categoryInclusions.put(category, Inclusion.INCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToIncludeAndReturn type(Class<?> type) {
            InclusionService.this.typeInclusions.put(type, Inclusion.INCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToIncludeAndReturn node(NodePath nodePath) {
            InclusionService.this.nodeInclusions.getNodeForPath(nodePath).setValue(Inclusion.INCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToIncludeAndReturn propertyName(String propertyName) {
            InclusionService.this.propertyNameInclusions.put(propertyName, Inclusion.INCLUDED);
            return this;
        }

        @Override
        public InclusionConfigurer.ToExclude exclude() {
            return InclusionService.this.exclude();
        }
    }
}

