/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff;

import de.danielbechler.diff.NodeQueryService;
import de.danielbechler.diff.ObjectDiffer;
import de.danielbechler.diff.category.CategoryConfigurer;
import de.danielbechler.diff.category.CategoryService;
import de.danielbechler.diff.circular.CircularReferenceConfigurer;
import de.danielbechler.diff.circular.CircularReferenceService;
import de.danielbechler.diff.comparison.ComparisonConfigurer;
import de.danielbechler.diff.comparison.ComparisonService;
import de.danielbechler.diff.comparison.ComparisonStrategy;
import de.danielbechler.diff.comparison.PrimitiveDefaultValueMode;
import de.danielbechler.diff.differ.BeanDiffer;
import de.danielbechler.diff.differ.CollectionDiffer;
import de.danielbechler.diff.differ.DifferConfigurer;
import de.danielbechler.diff.differ.DifferDispatcher;
import de.danielbechler.diff.differ.DifferFactory;
import de.danielbechler.diff.differ.DifferProvider;
import de.danielbechler.diff.differ.MapDiffer;
import de.danielbechler.diff.differ.PrimitiveDiffer;
import de.danielbechler.diff.filtering.FilteringConfigurer;
import de.danielbechler.diff.filtering.ReturnableNodeService;
import de.danielbechler.diff.inclusion.InclusionConfigurer;
import de.danielbechler.diff.inclusion.InclusionService;
import de.danielbechler.diff.introspection.IntrospectionConfigurer;
import de.danielbechler.diff.introspection.IntrospectionService;
import de.danielbechler.diff.introspection.Introspector;
import de.danielbechler.diff.node.DiffNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class ObjectDifferBuilder {
    private final IntrospectionService introspectionService = new IntrospectionService(this);
    private final CategoryService categoryService = new CategoryService(this);
    private final InclusionService inclusionService = new InclusionService(this.categoryService, this);
    private final ComparisonService comparisonService = new ComparisonService(this);
    private final ReturnableNodeService returnableNodeService = new ReturnableNodeService(this);
    private final CircularReferenceService circularReferenceService = new CircularReferenceService(this);
    private final DifferConfigurer differConfigurer = new DifferConfigurerImpl();
    private final NodeQueryService nodeQueryService = new NodeQueryServiceImpl();
    private final Collection<DifferFactory> differFactories = new ArrayList<DifferFactory>();

    private ObjectDifferBuilder() {
    }

    public static ObjectDiffer buildDefault() {
        return ObjectDifferBuilder.startBuilding().build();
    }

    public ObjectDiffer build() {
        DifferProvider differProvider = new DifferProvider();
        DifferDispatcher differDispatcher = new DifferDispatcher(differProvider, this.circularReferenceService, this.circularReferenceService, this.inclusionService, this.returnableNodeService);
        differProvider.push(new BeanDiffer(differDispatcher, this.introspectionService, this.returnableNodeService, this.comparisonService, this.introspectionService));
        differProvider.push(new CollectionDiffer(differDispatcher, this.comparisonService));
        differProvider.push(new MapDiffer(differDispatcher, this.comparisonService));
        differProvider.push(new PrimitiveDiffer(this.comparisonService));
        for (DifferFactory differFactory : this.differFactories) {
            differProvider.push(differFactory.createDiffer(differDispatcher, this.nodeQueryService));
        }
        return new ObjectDiffer(differDispatcher);
    }

    public static ObjectDifferBuilder startBuilding() {
        return new ObjectDifferBuilder();
    }

    public FilteringConfigurer filtering() {
        return this.returnableNodeService;
    }

    public IntrospectionConfigurer introspection() {
        return this.introspectionService;
    }

    public CircularReferenceConfigurer circularReferenceHandling() {
        return this.circularReferenceService;
    }

    public InclusionConfigurer inclusion() {
        return this.inclusionService;
    }

    public ComparisonConfigurer comparison() {
        return this.comparisonService;
    }

    public CategoryConfigurer categories() {
        return this.categoryService;
    }

    public DifferConfigurer differs() {
        return this.differConfigurer;
    }

    public class DifferConfigurerImpl
    implements DifferConfigurer {
        public ObjectDifferBuilder register(DifferFactory differFactory) {
            ObjectDifferBuilder.this.differFactories.add(differFactory);
            return ObjectDifferBuilder.this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NodeQueryServiceImpl
    implements NodeQueryService {
        private NodeQueryServiceImpl() {
        }

        @Override
        public Set<String> resolveCategories(DiffNode node) {
            return ObjectDifferBuilder.this.categoryService.resolveCategories(node);
        }

        @Override
        public Introspector introspectorForNode(DiffNode node) {
            return ObjectDifferBuilder.this.introspectionService.introspectorForNode(node);
        }

        @Override
        public boolean isIntrospectable(DiffNode node) {
            return ObjectDifferBuilder.this.introspectionService.isIntrospectable(node);
        }

        @Override
        public boolean isIgnored(DiffNode node) {
            return ObjectDifferBuilder.this.inclusionService.isIgnored(node);
        }

        @Override
        public boolean isReturnable(DiffNode node) {
            return ObjectDifferBuilder.this.returnableNodeService.isReturnable(node);
        }

        @Override
        public ComparisonStrategy resolveComparisonStrategy(DiffNode node) {
            return ObjectDifferBuilder.this.comparisonService.resolveComparisonStrategy(node);
        }

        @Override
        public PrimitiveDefaultValueMode resolvePrimitiveDefaultValueMode(DiffNode node) {
            return ObjectDifferBuilder.this.comparisonService.resolvePrimitiveDefaultValueMode(node);
        }
    }
}

