/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.identity;

import de.danielbechler.diff.identity.EqualsIdentityStrategy;
import de.danielbechler.diff.identity.IdentityConfigurer;
import de.danielbechler.diff.identity.IdentityStrategy;
import de.danielbechler.diff.identity.IdentityStrategyResolver;
import de.danielbechler.diff.identity.TypePropertyIdentityStrategyResolver;
import de.danielbechler.diff.inclusion.ValueNode;
import de.danielbechler.diff.node.DiffNode;
import de.danielbechler.diff.path.NodePath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectionItemIdentityService
implements IdentityStrategyResolver {
    private final ValueNode<IdentityStrategy> nodePathIdentityStrategies;
    private final TypePropertyIdentityStrategyResolver typePropertyIdentityStrategyResolver;
    private final IdentityConfigurer identityConfigurer;

    public CollectionItemIdentityService(IdentityConfigurer identityConfigurer) {
        this.identityConfigurer = identityConfigurer;
        this.nodePathIdentityStrategies = new ValueNode();
        this.typePropertyIdentityStrategyResolver = new TypePropertyIdentityStrategyResolver();
    }

    @Override
    public IdentityStrategy resolveIdentityStrategy(DiffNode node) {
        IdentityStrategy identityStrategy = this.typePropertyIdentityStrategyResolver.resolve(node);
        if (identityStrategy != null) {
            return identityStrategy;
        }
        identityStrategy = this.nodePathIdentityStrategies.getNodeForPath(node.getPath()).getValue();
        if (identityStrategy != null) {
            return identityStrategy;
        }
        return EqualsIdentityStrategy.getInstance();
    }

    public IdentityConfigurer.OfCollectionItems ofCollectionItems(NodePath nodePath) {
        return new OfCollectionItemsByNodePath(nodePath);
    }

    public IdentityConfigurer.OfCollectionItems ofCollectionItems(Class<?> type, String propertyName) {
        return new OfCollectionItemsByTypeProperty(type, propertyName);
    }

    private class OfCollectionItemsByNodePath
    implements IdentityConfigurer.OfCollectionItems {
        private final NodePath nodePath;

        public OfCollectionItemsByNodePath(NodePath nodePath) {
            this.nodePath = nodePath;
        }

        public IdentityConfigurer via(IdentityStrategy identityStrategy) {
            CollectionItemIdentityService.this.nodePathIdentityStrategies.getNodeForPath(this.nodePath).setValue(identityStrategy);
            return CollectionItemIdentityService.this.identityConfigurer;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class OfCollectionItemsByTypeProperty
    implements IdentityConfigurer.OfCollectionItems {
        private final Class<?> type;
        private final String propertyName;

        public OfCollectionItemsByTypeProperty(Class<?> type, String propertyName) {
            this.type = type;
            this.propertyName = propertyName;
        }

        @Override
        public IdentityConfigurer via(IdentityStrategy identityStrategy) {
            CollectionItemIdentityService.this.typePropertyIdentityStrategyResolver.setStrategy(identityStrategy, this.type, this.propertyName);
            return CollectionItemIdentityService.this.identityConfigurer;
        }
    }
}

