/*
 * Decompiled with CFR 0.152.
 */
package de.danielbechler.diff.circular;

import de.danielbechler.diff.ObjectDifferBuilder;
import de.danielbechler.diff.circular.CircularReferenceConfigurer;
import de.danielbechler.diff.circular.CircularReferenceDetector;
import de.danielbechler.diff.circular.CircularReferenceDetectorFactory;
import de.danielbechler.diff.circular.CircularReferenceExceptionHandler;
import de.danielbechler.diff.circular.CircularReferenceMatchingMode;
import de.danielbechler.diff.node.DiffNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircularReferenceService
implements CircularReferenceConfigurer,
CircularReferenceDetectorFactory,
CircularReferenceExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(CircularReferenceService.class);
    private final ObjectDifferBuilder objectDifferBuilder;
    private CircularReferenceMatchingMode circularReferenceMatchingMode = CircularReferenceMatchingMode.EQUALITY_OPERATOR;
    private CircularReferenceExceptionHandler circularReferenceExceptionHandler = new CircularReferenceExceptionHandler(){

        public void onCircularReferenceException(DiffNode node) {
            logger.warn("Detected circular reference in node at path {}. Going deeper would cause an infinite loop, so I'll stop looking at this instance along the current path.", (Object)node.getPath());
        }
    };

    public CircularReferenceService(ObjectDifferBuilder objectDifferBuilder) {
        this.objectDifferBuilder = objectDifferBuilder;
    }

    public CircularReferenceConfigurer matchCircularReferencesUsing(CircularReferenceMatchingMode matchingMode) {
        this.circularReferenceMatchingMode = matchingMode;
        return this;
    }

    public CircularReferenceConfigurer handleCircularReferenceExceptionsUsing(CircularReferenceExceptionHandler exceptionHandler) {
        this.circularReferenceExceptionHandler = exceptionHandler;
        return this;
    }

    public ObjectDifferBuilder and() {
        return this.objectDifferBuilder;
    }

    public CircularReferenceDetector createCircularReferenceDetector() {
        if (this.circularReferenceMatchingMode == CircularReferenceMatchingMode.EQUALS_METHOD) {
            return new CircularReferenceDetector(CircularReferenceDetector.ReferenceMatchingMode.EQUALS_METHOD);
        }
        if (this.circularReferenceMatchingMode == CircularReferenceMatchingMode.EQUALITY_OPERATOR) {
            return new CircularReferenceDetector(CircularReferenceDetector.ReferenceMatchingMode.EQUALITY_OPERATOR);
        }
        throw new IllegalStateException();
    }

    public void onCircularReferenceException(DiffNode node) {
        if (this.circularReferenceExceptionHandler != null) {
            this.circularReferenceExceptionHandler.onCircularReferenceException(node);
        }
    }
}

