/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.eqtests.basic;

import de.learnlib.api.EquivalenceOracle;
import de.learnlib.api.MembershipOracle;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.automatalib.automata.concepts.OutputAutomaton;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWordsEQOracle<I, O, A extends OutputAutomaton<?, I, ?, O>>
implements EquivalenceOracle<A, I, O> {
    private MembershipOracle<I, O> oracle;
    private int maxTests;
    private int minLength;
    private int maxLength;
    private final Random random;

    public RandomWordsEQOracle(MembershipOracle<I, O> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
        this.oracle = mqOracle;
        this.maxTests = maxTests;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.random = random;
    }

    public DefaultQuery<I, O> findCounterExample(A hypothesis, Collection<? extends I> alpha) {
        ArrayList<I> symbolList = alpha instanceof List ? (ArrayList<I>)alpha : new ArrayList<I>(alpha);
        int numSyms = symbolList.size();
        for (int i = 0; i < this.maxTests; ++i) {
            int length = this.minLength + this.random.nextInt(this.maxLength - this.minLength + 1);
            WordBuilder testtrace = new WordBuilder(length);
            for (int j = 0; j < length; ++j) {
                int symidx = this.random.nextInt(numSyms);
                Object sym = symbolList.get(symidx);
                testtrace.append(sym);
            }
            DefaultQuery query = new DefaultQuery(testtrace.toWord());
            this.oracle.processQueries(Collections.singletonList(query));
            Object oracleoutput = query.getOutput();
            Object hypOutput = hypothesis.computeOutput((Iterable)testtrace.toWord());
            if (oracleoutput.equals(hypOutput)) continue;
            return query;
        }
        return null;
    }

    public static class MealyRandomWordsEQOracle<I, O>
    extends RandomWordsEQOracle<I, Word<O>, MealyMachine<?, I, ?, O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyRandomWordsEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
            super(mqOracle, minLength, maxLength, maxTests, random);
        }
    }

    public static class DFARandomWordsEQOracle<I>
    extends RandomWordsEQOracle<I, Boolean, DFA<?, I>>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFARandomWordsEQOracle(MembershipOracle<I, Boolean> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
            super(mqOracle, minLength, maxLength, maxTests, random);
        }
    }
}

