/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.tutorials;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.quantummaid.httpmaid.HttpMaid;
import de.quantummaid.httpmaid.events.EventConfigurators;
import de.quantummaid.httpmaid.usecases.UseCaseConfigurators;
import de.quantummaid.quantummaid.QuantumMaid;
import de.quantummaid.quantummaid.integrations.guice.QuantumMaidGuiceBindings;
import de.quantummaid.tutorials.GreetingUseCase;

public final class WebService {
    private static final int PORT = 8080;

    public static QuantumMaid createQuantumMaid(int port) {
        Injector injector = Guice.createInjector((Module[])new Module[]{QuantumMaidGuiceBindings.bindToSinglePublicConstructor(GreetingUseCase.class)});
        HttpMaid httpMaid = HttpMaid.anHttpMaid().get("/hello/<name>", GreetingUseCase.class).configured(EventConfigurators.toEnrichTheIntermediateMapWithAllPathParameters()).configured(UseCaseConfigurators.toCreateUseCaseInstancesUsing(arg_0 -> ((Injector)injector).getInstance(arg_0))).build();
        return QuantumMaid.quantumMaid().withHttpMaid(httpMaid).withLocalHostEndpointOnPort(port);
    }

    public static void main(String[] args) {
        WebService.createQuantumMaid(8080).run();
    }
}

