/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.exceptions;

import de.quantummaid.httpmaid.CoreModule;
import de.quantummaid.httpmaid.chains.Configurator;
import de.quantummaid.httpmaid.exceptions.HttpExceptionMapper;
import de.quantummaid.httpmaid.util.Validators;
import java.util.function.Predicate;

public final class ExceptionConfigurators {
    private ExceptionConfigurators() {
    }

    public static Configurator toMapExceptionsByDefaultUsing(HttpExceptionMapper<Throwable> mapper) {
        Validators.validateNotNull(mapper, "mapper");
        return Configurator.configuratorForType(CoreModule.class, coreModule -> coreModule.setDefaultExceptionMapper(mapper));
    }

    public static <T extends Throwable> Configurator toMapExceptionsOfType(Class<T> type, HttpExceptionMapper<T> mapper) {
        Validators.validateNotNull(type, "type");
        Validators.validateNotNull(mapper, "mapper");
        return Configurator.configuratorForType(CoreModule.class, coreModule -> coreModule.addExceptionMapper(ExceptionConfigurators.areOfType(type), mapper));
    }

    private static Predicate<Throwable> areOfType(Class<? extends Throwable> type) {
        return type::isInstance;
    }
}

