/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.httpmaid.websockets.disconnect;

import de.quantummaid.httpmaid.util.Validators;
import de.quantummaid.httpmaid.websockets.broadcast.RecipientDeterminator;
import de.quantummaid.httpmaid.websockets.registry.ConnectionInformation;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistry;
import de.quantummaid.httpmaid.websockets.registry.WebsocketRegistryEntry;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSender;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenderId;
import de.quantummaid.httpmaid.websockets.sender.WebsocketSenders;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Disconnector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Disconnector.class);
    private final WebsocketRegistry websocketRegistry;
    private final WebsocketSenders websocketSenders;

    public static Disconnector disconnector(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders) {
        return new Disconnector(websocketRegistry, websocketSenders);
    }

    public void disconnectAll() {
        this.disconnectAllThat(RecipientDeterminator.all());
    }

    public void disconnectAllThat(RecipientDeterminator recipientDeterminator) {
        Validators.validateNotNull(recipientDeterminator, "recipientDeterminator");
        List<WebsocketRegistryEntry> connections = this.websocketRegistry.connections();
        connections.forEach(connection -> {
            WebsocketSenderId websocketSenderId = connection.senderId();
            WebsocketSender<Object> sender = this.websocketSenders.senderById(websocketSenderId);
            ConnectionInformation connectionInformation = connection.connectionInformation();
            try {
                sender.disconnect(connectionInformation);
            }
            catch (Exception e) {
                log.info("Exception when disconnecting websocket {}.", (Object)connectionInformation, (Object)e);
            }
            this.websocketRegistry.removeConnection(connectionInformation);
        });
    }

    @Generated
    private Disconnector(WebsocketRegistry websocketRegistry, WebsocketSenders websocketSenders) {
        this.websocketRegistry = websocketRegistry;
        this.websocketSenders = websocketSenders;
    }
}

