/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid;

import de.quantummaid.injectmaid.Definition;
import de.quantummaid.injectmaid.Definitions;
import de.quantummaid.injectmaid.InjectMaidBuilder;
import de.quantummaid.injectmaid.InjectMaidException;
import de.quantummaid.injectmaid.ReusePolicy;
import de.quantummaid.injectmaid.Scope;
import de.quantummaid.injectmaid.ScopeManager;
import de.quantummaid.injectmaid.SingletonStore;
import de.quantummaid.injectmaid.SingletonType;
import de.quantummaid.injectmaid.circledetector.CircularDependencyDetector;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import de.quantummaid.injectmaid.interception.Interceptors;
import de.quantummaid.injectmaid.interception.SimpleInterceptor;
import de.quantummaid.injectmaid.interception.overwrite.OverwritingInterceptor;
import de.quantummaid.reflectmaid.GenericType;
import de.quantummaid.reflectmaid.ResolvedType;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;

public final class InjectMaid {
    private final Definitions definitions;
    private final SingletonType defaultSingletonType;
    private final SingletonStore singletonStore;
    private final Scope scope;
    private final ScopeManager scopeManager;
    private final Interceptors interceptors;

    public static InjectMaidBuilder anInjectMaid() {
        return InjectMaidBuilder.injectionMaidBuilder();
    }

    static InjectMaid injectMaid(Definitions definitions, SingletonType defaultSingletonType) {
        CircularDependencyDetector.validateNoCircularDependencies(definitions);
        Scope scope = Scope.rootScope();
        ScopeManager scopeManager = ScopeManager.scopeManager();
        Interceptors interceptors = Interceptors.interceptors();
        return InjectMaid.initInScope(definitions, defaultSingletonType, scope, scopeManager, interceptors);
    }

    private static InjectMaid initInScope(Definitions definitions, SingletonType defaultSingletonType, Scope scope, ScopeManager scopeManager, Interceptors interceptors) {
        SingletonStore singletonStore = SingletonStore.singletonStore();
        InjectMaid injectMaid = new InjectMaid(definitions, defaultSingletonType, singletonStore, scope, scopeManager, interceptors);
        injectMaid.loadEagerSingletons();
        return injectMaid;
    }

    public void initializeAllSingletons() {
        this.definitions.definitionsOnScope(this.scope).stream().filter(Definition::isSingleton).forEach(this::internalGetInstance);
    }

    private void loadEagerSingletons() {
        this.definitions.definitionsOnScope(this.scope).stream().filter(this::isEagerSingleton).forEach(this::internalGetInstance);
    }

    private boolean isEagerSingleton(Definition definition) {
        ReusePolicy reusePolicy = definition.reusePolicy();
        if (reusePolicy == ReusePolicy.SINGLETON) {
            return this.defaultSingletonType == SingletonType.EAGER;
        }
        return reusePolicy == ReusePolicy.EAGER_SINGLETON;
    }

    public <T> InjectMaid enterScope(Class<T> scopeType, T scopeObject) {
        GenericType<T> genericType = GenericType.genericType(scopeType);
        return this.enterScope(genericType, scopeObject);
    }

    public <T> InjectMaid enterScope(GenericType<T> scopeType, T scopeObject) {
        ResolvedType resolvedType = scopeType.toResolvedType();
        return this.enterScope(resolvedType, scopeObject);
    }

    public InjectMaid enterScope(ResolvedType resolvedType, Object scopeObject) {
        Scope childScope = this.scope.childScope(resolvedType);
        List<Scope> scopes = this.definitions.allScopes();
        if (!scopes.contains(childScope)) {
            String registeredScopes = scopes.stream().map(Scope::render).sorted().collect(Collectors.joining(", ", "[", "]"));
            throw InjectMaidException.injectMaidException(String.format("Tried to enter unknown scope '%s' with object '%s'. Registered scopes: %s", childScope.render(), scopeObject, registeredScopes));
        }
        SingletonStore childSingletonStore = this.singletonStore.child(resolvedType);
        ScopeManager childScopeManager = this.scopeManager.add(resolvedType, scopeObject);
        Interceptors childInterceptors = this.interceptors.enterScope(resolvedType, scopeObject);
        return new InjectMaid(this.definitions, this.defaultSingletonType, childSingletonStore, childScope, childScopeManager, childInterceptors);
    }

    public void addInterceptor(SimpleInterceptor interceptor) {
        this.interceptors.addInterceptor(interceptor);
    }

    public void overwriteWith(InjectMaid injectMaid) {
        OverwritingInterceptor interceptor = OverwritingInterceptor.overwritingInterceptor(injectMaid);
        this.interceptors.addInterceptor(interceptor);
    }

    public <T> T getInstance(Class<T> type) {
        GenericType<T> genericType = GenericType.genericType(type);
        return this.getInstance(genericType);
    }

    public <T> T getInstance(GenericType<T> genericType) {
        ResolvedType resolvedType = genericType.toResolvedType();
        return (T)this.getInstance(resolvedType);
    }

    public Object getInstance(ResolvedType type) {
        Optional<?> intercepted = this.interceptors.interceptBefore(type);
        if (intercepted.isPresent()) {
            return intercepted.get();
        }
        Definition definition = this.definitions.definitionFor(type, this.scope);
        Object instance = this.internalGetInstance(definition);
        return this.interceptors.interceptAfter(type, instance);
    }

    public boolean canInstantiate(Class<?> type) {
        GenericType<?> genericType = GenericType.genericType(type);
        return this.canInstantiate(genericType);
    }

    public boolean canInstantiate(GenericType<?> type) {
        ResolvedType resolvedType = type.toResolvedType();
        return this.canInstantiate(resolvedType);
    }

    public boolean canInstantiate(ResolvedType resolvedType) {
        return this.definitions.hasDefinitionFor(resolvedType, this.scope);
    }

    public String debugInformation() {
        return this.definitions.dump();
    }

    private Object internalGetInstance(Definition definition) {
        return this.createAndRegister(definition, () -> this.instantiate(definition));
    }

    private Object instantiate(Definition definition) {
        Instantiator instantiator = definition.instantiator();
        List<Object> dependencies = this.instantiateDependencies(instantiator);
        try {
            return instantiator.instantiate(dependencies, this.scopeManager);
        }
        catch (Exception e) {
            throw InjectMaidException.injectMaidException(String.format("Exception during instantiation of '%s' using %s", definition.type().simpleDescription(), instantiator.description()), e);
        }
    }

    private List<Object> instantiateDependencies(Instantiator instantiator) {
        return instantiator.dependencies().stream().map(this::getInstance).collect(Collectors.toList());
    }

    private Object createAndRegister(Definition definition, Supplier<Object> instantiator) {
        boolean singleton = definition.isSingleton();
        ResolvedType type = definition.type();
        Scope definitionScope = definition.scope();
        if (singleton && this.singletonStore.contains(type, definitionScope)) {
            return this.singletonStore.get(type, definitionScope);
        }
        Object instance = instantiator.get();
        if (singleton) {
            this.singletonStore.put(type, definitionScope, instance);
        }
        return instance;
    }

    @Generated
    public String toString() {
        return "InjectMaid(definitions=" + this.definitions + ", defaultSingletonType=" + this.defaultSingletonType + ", singletonStore=" + this.singletonStore + ", scope=" + this.scope + ", scopeManager=" + this.scopeManager + ", interceptors=" + this.interceptors + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InjectMaid)) {
            return false;
        }
        InjectMaid other = (InjectMaid)o;
        Definitions this$definitions = this.definitions;
        Definitions other$definitions = other.definitions;
        if (this$definitions == null ? other$definitions != null : !((Object)this$definitions).equals(other$definitions)) {
            return false;
        }
        SingletonType this$defaultSingletonType = this.defaultSingletonType;
        SingletonType other$defaultSingletonType = other.defaultSingletonType;
        if (this$defaultSingletonType == null ? other$defaultSingletonType != null : !((Object)((Object)this$defaultSingletonType)).equals((Object)other$defaultSingletonType)) {
            return false;
        }
        SingletonStore this$singletonStore = this.singletonStore;
        SingletonStore other$singletonStore = other.singletonStore;
        if (this$singletonStore == null ? other$singletonStore != null : !((Object)this$singletonStore).equals(other$singletonStore)) {
            return false;
        }
        Scope this$scope = this.scope;
        Scope other$scope = other.scope;
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        ScopeManager this$scopeManager = this.scopeManager;
        ScopeManager other$scopeManager = other.scopeManager;
        if (this$scopeManager == null ? other$scopeManager != null : !((Object)this$scopeManager).equals(other$scopeManager)) {
            return false;
        }
        Interceptors this$interceptors = this.interceptors;
        Interceptors other$interceptors = other.interceptors;
        return !(this$interceptors == null ? other$interceptors != null : !((Object)this$interceptors).equals(other$interceptors));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Definitions $definitions = this.definitions;
        result = result * 59 + ($definitions == null ? 43 : ((Object)$definitions).hashCode());
        SingletonType $defaultSingletonType = this.defaultSingletonType;
        result = result * 59 + ($defaultSingletonType == null ? 43 : ((Object)((Object)$defaultSingletonType)).hashCode());
        SingletonStore $singletonStore = this.singletonStore;
        result = result * 59 + ($singletonStore == null ? 43 : ((Object)$singletonStore).hashCode());
        Scope $scope = this.scope;
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        ScopeManager $scopeManager = this.scopeManager;
        result = result * 59 + ($scopeManager == null ? 43 : ((Object)$scopeManager).hashCode());
        Interceptors $interceptors = this.interceptors;
        result = result * 59 + ($interceptors == null ? 43 : ((Object)$interceptors).hashCode());
        return result;
    }

    @Generated
    private InjectMaid(Definitions definitions, SingletonType defaultSingletonType, SingletonStore singletonStore, Scope scope, ScopeManager scopeManager, Interceptors interceptors) {
        this.definitions = definitions;
        this.defaultSingletonType = defaultSingletonType;
        this.singletonStore = singletonStore;
        this.scope = scope;
        this.scopeManager = scopeManager;
        this.interceptors = interceptors;
    }
}

