/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection.disambiguators;

import de.quantummaid.injectmaid.detection.InstantiationOptions;
import de.quantummaid.injectmaid.detection.disambiguators.DisambiguationResult;
import de.quantummaid.injectmaid.detection.disambiguators.Disambiguator;
import de.quantummaid.injectmaid.instantiator.ConstructorInstantiator;
import de.quantummaid.injectmaid.instantiator.Instantiator;
import java.util.List;
import lombok.Generated;

public final class SingleConstructorDisambiguator
implements Disambiguator {
    public static SingleConstructorDisambiguator singleConstructorDisambiguator() {
        return new SingleConstructorDisambiguator();
    }

    @Override
    public DisambiguationResult disambiguate(InstantiationOptions instantiationOptions) {
        List<ConstructorInstantiator> constructors = instantiationOptions.constructors();
        if (constructors.isEmpty()) {
            return DisambiguationResult.ignore("No public constructors found");
        }
        if (constructors.size() > 1) {
            return DisambiguationResult.ignore("More than one public constructors found");
        }
        Instantiator instantiator = constructors.get(0);
        return DisambiguationResult.success(instantiator);
    }

    @Generated
    public String toString() {
        return "SingleConstructorDisambiguator()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof SingleConstructorDisambiguator;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private SingleConstructorDisambiguator() {
    }
}

