/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.injectmaid.detection.disambiguators;

import de.quantummaid.injectmaid.detection.InstantiationOptions;
import de.quantummaid.injectmaid.detection.disambiguators.DisambiguationResult;
import de.quantummaid.injectmaid.detection.disambiguators.Disambiguator;
import de.quantummaid.injectmaid.instantiator.StaticFactoryInstantiator;
import java.util.List;
import lombok.Generated;

public final class SingleStaticFactoryDisambiguator
implements Disambiguator {
    public static SingleStaticFactoryDisambiguator singleStaticFactoryDisambiguator() {
        return new SingleStaticFactoryDisambiguator();
    }

    @Override
    public DisambiguationResult disambiguate(InstantiationOptions instantiationOptions) {
        if (!instantiationOptions.constructors().isEmpty()) {
            return DisambiguationResult.ignore("Static factories are not considered because public constructors have been found");
        }
        List<StaticFactoryInstantiator> factoryMethods = instantiationOptions.staticFactoryMethods();
        if (factoryMethods.isEmpty()) {
            return DisambiguationResult.ignore("No static factory methods have been found");
        }
        if (factoryMethods.size() > 1) {
            return DisambiguationResult.ignore("More than one factory method has been found");
        }
        StaticFactoryInstantiator instantiator = factoryMethods.get(0);
        return DisambiguationResult.success(instantiator);
    }

    @Generated
    public String toString() {
        return "SingleStaticFactoryDisambiguator()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof SingleStaticFactoryDisambiguator;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    private SingleStaticFactoryDisambiguator() {
    }
}

