/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.detection;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public final class DetectionResult<T> {
    private final T result;
    private final List<String> reasonsForFailure;

    public static <A, B, C> DetectionResult<C> combine(DetectionResult<A> a, DetectionResult<B> b, BiFunction<A, B, C> combinator) {
        if (!a.isFailure() && !b.isFailure()) {
            C combination = combinator.apply(a.result, b.result);
            return DetectionResult.success(combination);
        }
        List<String> combinedReasons = Collection.smallList();
        combinedReasons.addAll(a.reasonsForFailure);
        combinedReasons.addAll(b.reasonsForFailure);
        return DetectionResult.failure(combinedReasons);
    }

    public static <T> DetectionResult<T> success(T result) {
        NotNullValidator.validateNotNull(result, "result");
        return new DetectionResult<T>(result, Collections.emptyList());
    }

    public static <T> DetectionResult<T> failure(String reasonForFailure) {
        NotNullValidator.validateNotNull(reasonForFailure, "reasonForFailure");
        return DetectionResult.failure(Collections.singletonList(reasonForFailure));
    }

    public static <T> DetectionResult<T> failure(List<String> reasonsForFailure) {
        NotNullValidator.validateNotNull(reasonsForFailure, "reasonsForFailure");
        return new DetectionResult<Object>(null, reasonsForFailure);
    }

    public static <T> DetectionResult<T> followUpFailure(DetectionResult<?> ... detectionResults) {
        List<String> combinedReasons = Collection.smallList();
        for (DetectionResult<?> result : detectionResults) {
            if (!result.isFailure()) {
                throw new IllegalArgumentException("Can only follow up on failures");
            }
            combinedReasons.addAll(result.reasonsForFailure);
        }
        return DetectionResult.failure(combinedReasons);
    }

    public void ifSuccess(Consumer<T> consumer) {
        if (this.isSuccess()) {
            consumer.accept(this.result);
        }
    }

    public boolean isFailure() {
        return !this.reasonsForFailure.isEmpty();
    }

    public boolean isSuccess() {
        return !this.isFailure();
    }

    public String reasonForFailure() {
        return this.reasonsForFailure.stream().collect(Collectors.joining("\n", "[", "]"));
    }

    public T result() {
        return this.result;
    }

    public <X> DetectionResult<X> map(Function<T, X> mapper) {
        if (this.isFailure()) {
            return this;
        }
        X mapped = mapper.apply(this.result);
        return DetectionResult.success(mapped);
    }

    public <X> DetectionResult<X> flatMap(Function<T, DetectionResult<X>> mapper) {
        if (this.isFailure()) {
            return this;
        }
        return mapper.apply(this.result);
    }

    @Generated
    public String toString() {
        return "DetectionResult(result=" + this.result + ", reasonsForFailure=" + this.reasonsForFailure + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DetectionResult)) {
            return false;
        }
        DetectionResult other = (DetectionResult)o;
        T this$result = this.result;
        T other$result = other.result;
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        List<String> this$reasonsForFailure = this.reasonsForFailure;
        List<String> other$reasonsForFailure = other.reasonsForFailure;
        return !(this$reasonsForFailure == null ? other$reasonsForFailure != null : !((Object)this$reasonsForFailure).equals(other$reasonsForFailure));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        T $result = this.result;
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        List<String> $reasonsForFailure = this.reasonsForFailure;
        result = result * 59 + ($reasonsForFailure == null ? 43 : ((Object)$reasonsForFailure).hashCode());
        return result;
    }

    @Generated
    private DetectionResult(T result, List<String> reasonsForFailure) {
        this.result = result;
        this.reasonsForFailure = reasonsForFailure;
    }
}

