/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal;

import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.CommonFilters;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.CommonPreferences;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.CommonTieBreakers;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.DisambiguationContext;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.NormalDisambiguator;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Filters;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.preferences.Preferences;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.tiebreaker.TieBreaker;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveAsEnumDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.serializedobjects.MethodSerializedObjectDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.EnumCustomPrimitiveSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.serializedobject.SerializationField;
import java.util.List;
import lombok.Generated;

public final class DisambiguatorBuilder {
    private String preferredCustomPrimitiveFactoryName = "fromStringValue";
    private String preferredCustomPrimitiveSerializationMethodName = "stringValue";
    private String preferredSerializedObjectFactoryName = "deserialize";

    public static DisambiguatorBuilder defaultDisambiguatorBuilder() {
        return new DisambiguatorBuilder();
    }

    public void setPreferredCustomPrimitiveFactoryName(String preferredCustomPrimitiveFactoryName) {
        this.preferredCustomPrimitiveFactoryName = preferredCustomPrimitiveFactoryName;
    }

    public void setPreferredCustomPrimitiveSerializationMethodName(String preferredCustomPrimitiveSerializationMethodName) {
        this.preferredCustomPrimitiveSerializationMethodName = preferredCustomPrimitiveSerializationMethodName;
    }

    public void setPreferredSerializedObjectFactoryName(String preferredSerializedObjectFactoryName) {
        this.preferredSerializedObjectFactoryName = preferredSerializedObjectFactoryName;
    }

    public NormalDisambiguator build() {
        Preferences<TypeDeserializer, DisambiguationContext> customPrimitiveDeserializerPreferences = this.buildCustomPrimitiveDeserializerPreferences();
        Preferences<TypeSerializer, DisambiguationContext> customPrimitiveSerializerPreferences = this.buildCustomPrimitiveSerializerPreferences();
        Preferences<TypeDeserializer, DisambiguationContext> serializedObjectPreferences = this.buildSerializedObjectPreferences();
        Filters<SerializationField, DisambiguationContext> serializationFieldFilters = this.buildSerializationFieldFilters();
        Preferences<SerializationField, DisambiguationContext> postSymmetrySerializationFieldPreferences = Preferences.preferences(List.of(CommonPreferences.publicFields()));
        TieBreaker tieBreaker = this.buildTieBreaker();
        return NormalDisambiguator.normalDisambiguator(customPrimitiveDeserializerPreferences, customPrimitiveSerializerPreferences, serializedObjectPreferences, serializationFieldFilters, postSymmetrySerializationFieldPreferences, tieBreaker);
    }

    private Preferences<TypeDeserializer, DisambiguationContext> buildCustomPrimitiveDeserializerPreferences() {
        return Preferences.preferences(List.of(CommonFilters.ignoreNonPublicMethodsForCustomPrimitiveDeserialization(), CommonFilters.ignoreNonPublicConstructorsForCustomPrimitiveDeserialization()), List.of(deserializer -> deserializer instanceof CustomPrimitiveAsEnumDeserializer, CommonPreferences.customPrimitiveFactoryNamed(this.preferredCustomPrimitiveFactoryName), CommonPreferences.customPrimitiveFactoryWithSameNameAsClass()));
    }

    private Preferences<TypeSerializer, DisambiguationContext> buildCustomPrimitiveSerializerPreferences() {
        return Preferences.preferences(List.of(CommonFilters.ignoreNonPublicMethodsForCustomPrimitiveSerialization(), CommonFilters.ignoreComponentMethodsForKotlinCustomPrimitiveSerialization(), CommonFilters.nameOfSerializerMethodIsNot("toString"), CommonFilters.nameOfSerializerMethodIsNot("hashCode")), List.of(serializer -> serializer instanceof EnumCustomPrimitiveSerializer, CommonPreferences.customPrimitiveSerializerNamed(this.preferredCustomPrimitiveSerializationMethodName)));
    }

    private Preferences<TypeDeserializer, DisambiguationContext> buildSerializedObjectPreferences() {
        return Preferences.preferences(List.of(CommonFilters.ignoreNonPublicMethodsForSerializedObjectDeserialization(), CommonFilters.ignoreNonPublicConstructorsForSerializedObjectDeserialization()), List.of(CommonPreferences.serializedObjectFactoryNamed(this.preferredSerializedObjectFactoryName), CommonPreferences.serializedObjectFactoryWithSameNameAsClass(), deserializer -> deserializer instanceof MethodSerializedObjectDeserializer));
    }

    private Filters<SerializationField, DisambiguationContext> buildSerializationFieldFilters() {
        return Filters.filters(List.of(CommonFilters.ignoreStaticFields(), CommonFilters.ignoreTransientFields(), CommonFilters.ignoreNonPublicFields(), CommonFilters.ignoreInjectedFields()));
    }

    private TieBreaker buildTieBreaker() {
        return TieBreaker.tieBreaker(List.of(CommonTieBreakers.primitiveSerializationMethodNamed(this.preferredCustomPrimitiveSerializationMethodName)), List.of(), List.of(CommonTieBreakers.primitiveFactoryNamed(this.preferredCustomPrimitiveFactoryName)), List.of(CommonTieBreakers.serializedObjectFactoryNamed(this.preferredSerializedObjectFactoryName)));
    }

    @Generated
    public String toString() {
        return "DisambiguatorBuilder(preferredCustomPrimitiveFactoryName=" + this.preferredCustomPrimitiveFactoryName + ", preferredCustomPrimitiveSerializationMethodName=" + this.preferredCustomPrimitiveSerializationMethodName + ", preferredSerializedObjectFactoryName=" + this.preferredSerializedObjectFactoryName + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisambiguatorBuilder)) {
            return false;
        }
        DisambiguatorBuilder other = (DisambiguatorBuilder)o;
        String this$preferredCustomPrimitiveFactoryName = this.preferredCustomPrimitiveFactoryName;
        String other$preferredCustomPrimitiveFactoryName = other.preferredCustomPrimitiveFactoryName;
        if (this$preferredCustomPrimitiveFactoryName == null ? other$preferredCustomPrimitiveFactoryName != null : !this$preferredCustomPrimitiveFactoryName.equals(other$preferredCustomPrimitiveFactoryName)) {
            return false;
        }
        String this$preferredCustomPrimitiveSerializationMethodName = this.preferredCustomPrimitiveSerializationMethodName;
        String other$preferredCustomPrimitiveSerializationMethodName = other.preferredCustomPrimitiveSerializationMethodName;
        if (this$preferredCustomPrimitiveSerializationMethodName == null ? other$preferredCustomPrimitiveSerializationMethodName != null : !this$preferredCustomPrimitiveSerializationMethodName.equals(other$preferredCustomPrimitiveSerializationMethodName)) {
            return false;
        }
        String this$preferredSerializedObjectFactoryName = this.preferredSerializedObjectFactoryName;
        String other$preferredSerializedObjectFactoryName = other.preferredSerializedObjectFactoryName;
        return !(this$preferredSerializedObjectFactoryName == null ? other$preferredSerializedObjectFactoryName != null : !this$preferredSerializedObjectFactoryName.equals(other$preferredSerializedObjectFactoryName));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $preferredCustomPrimitiveFactoryName = this.preferredCustomPrimitiveFactoryName;
        result = result * 59 + ($preferredCustomPrimitiveFactoryName == null ? 43 : $preferredCustomPrimitiveFactoryName.hashCode());
        String $preferredCustomPrimitiveSerializationMethodName = this.preferredCustomPrimitiveSerializationMethodName;
        result = result * 59 + ($preferredCustomPrimitiveSerializationMethodName == null ? 43 : $preferredCustomPrimitiveSerializationMethodName.hashCode());
        String $preferredSerializedObjectFactoryName = this.preferredSerializedObjectFactoryName;
        result = result * 59 + ($preferredSerializedObjectFactoryName == null ? 43 : $preferredSerializedObjectFactoryName.hashCode());
        return result;
    }

    @Generated
    private DisambiguatorBuilder() {
    }
}

