/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.customprimitive;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.conventional.ConventionalDefinitionFactories;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.SerializersAndDeserializers;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.customprimitives.CustomPrimitiveDeserializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.TypeSerializer;
import de.quantummaid.mapmaid.mapper.serialization.serializers.customprimitives.CustomPrimitiveSerializer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class CustomPrimitiveSymmetryBuilder {
    private final List<Class<?>> customPrimitiveBaseTypes;
    private final Map<Class<?>, List<TypeSerializer>> serializers;
    private final Map<Class<?>, List<TypeDeserializer>> deserializers;

    public static CustomPrimitiveSymmetryBuilder customPrimitiveSymmetryBuilder() {
        return new CustomPrimitiveSymmetryBuilder(ConventionalDefinitionFactories.CUSTOM_PRIMITIVE_MAPPINGS.registeredTypes(), Collection.smallMap(), Collection.smallMap());
    }

    private static <T> void ensureKeyIsPresent(Class<?> type, Map<Class<?>, List<T>> map) {
        if (!map.containsKey(type)) {
            map.put(type, Collection.smallList());
        }
    }

    public void addDeserializer(CustomPrimitiveDeserializer deserializer) {
        Class<?> baseType = deserializer.baseType();
        CustomPrimitiveSymmetryBuilder.ensureKeyIsPresent(baseType, this.deserializers);
        this.deserializers.get(baseType).add(deserializer);
    }

    public void addSerializer(CustomPrimitiveSerializer serializer) {
        Class<?> baseType = serializer.baseType();
        CustomPrimitiveSymmetryBuilder.ensureKeyIsPresent(baseType, this.serializers);
        this.serializers.get(baseType).add(serializer);
    }

    public Optional<SerializersAndDeserializers> determineGreatestCommonFields() {
        for (Class<?> baseType : this.customPrimitiveBaseTypes) {
            if (!this.serializers.containsKey(baseType) || !this.deserializers.containsKey(baseType)) continue;
            SerializersAndDeserializers serializersAndDeserializers = SerializersAndDeserializers.serializersAndDeserializers(this.serializers.get(baseType), this.deserializers.get(baseType));
            return Optional.of(serializersAndDeserializers);
        }
        return Optional.empty();
    }

    @Generated
    public String toString() {
        return "CustomPrimitiveSymmetryBuilder(customPrimitiveBaseTypes=" + this.customPrimitiveBaseTypes + ", serializers=" + this.serializers + ", deserializers=" + this.deserializers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomPrimitiveSymmetryBuilder)) {
            return false;
        }
        CustomPrimitiveSymmetryBuilder other = (CustomPrimitiveSymmetryBuilder)o;
        List<Class<?>> this$customPrimitiveBaseTypes = this.customPrimitiveBaseTypes;
        List<Class<?>> other$customPrimitiveBaseTypes = other.customPrimitiveBaseTypes;
        if (this$customPrimitiveBaseTypes == null ? other$customPrimitiveBaseTypes != null : !((Object)this$customPrimitiveBaseTypes).equals(other$customPrimitiveBaseTypes)) {
            return false;
        }
        Map<Class<?>, List<TypeSerializer>> this$serializers = this.serializers;
        Map<Class<?>, List<TypeSerializer>> other$serializers = other.serializers;
        if (this$serializers == null ? other$serializers != null : !((Object)this$serializers).equals(other$serializers)) {
            return false;
        }
        Map<Class<?>, List<TypeDeserializer>> this$deserializers = this.deserializers;
        Map<Class<?>, List<TypeDeserializer>> other$deserializers = other.deserializers;
        return !(this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Class<?>> $customPrimitiveBaseTypes = this.customPrimitiveBaseTypes;
        result = result * 59 + ($customPrimitiveBaseTypes == null ? 43 : ((Object)$customPrimitiveBaseTypes).hashCode());
        Map<Class<?>, List<TypeSerializer>> $serializers = this.serializers;
        result = result * 59 + ($serializers == null ? 43 : ((Object)$serializers).hashCode());
        Map<Class<?>, List<TypeDeserializer>> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        return result;
    }

    @Generated
    private CustomPrimitiveSymmetryBuilder(List<Class<?>> customPrimitiveBaseTypes, Map<Class<?>, List<TypeSerializer>> serializers, Map<Class<?>, List<TypeDeserializer>> deserializers) {
        this.customPrimitiveBaseTypes = customPrimitiveBaseTypes;
        this.serializers = serializers;
        this.deserializers = deserializers;
    }
}

