/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.disambiguator.normal.symmetry.serializedobject;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.detection.serializedobject.SerializationFieldInstantiation;
import de.quantummaid.mapmaid.mapper.deserialization.deserializers.TypeDeserializer;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.List;
import java.util.Objects;
import lombok.Generated;

public final class EquivalenceClass {
    private final int size;
    private SerializationFieldInstantiation serializationFields;
    private final List<TypeDeserializer> deserializers;

    public static EquivalenceClass equivalenceClass(int size) {
        return new EquivalenceClass(size, Collection.smallList());
    }

    public void setSerializationFields(SerializationFieldInstantiation serializationFields) {
        NotNullValidator.validateNotNull(serializationFields, "serializer");
        if (this.serializationFields != null) {
            throw new UnsupportedOperationException("serialized fields can only be set once");
        }
        this.serializationFields = serializationFields;
    }

    public void addDeserializer(TypeDeserializer deserializer) {
        NotNullValidator.validateNotNull(deserializer, "deserializer");
        this.deserializers.add(deserializer);
    }

    public boolean fullySupported() {
        return Objects.nonNull(this.serializationFields) && !this.deserializers.isEmpty();
    }

    public int size() {
        return this.size;
    }

    public SerializationFieldInstantiation serializationFields() {
        return this.serializationFields;
    }

    public List<TypeDeserializer> deserializers() {
        return this.deserializers;
    }

    public String describe() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("fields:\n");
        stringBuilder.append(this.serializationFields.describe());
        stringBuilder.append("\n");
        stringBuilder.append("deserializers:\n");
        this.deserializers.forEach(deserializer -> {
            stringBuilder.append(deserializer.description());
            stringBuilder.append("\n");
        });
        return stringBuilder.toString();
    }

    @Generated
    public String toString() {
        return "EquivalenceClass(size=" + this.size + ", serializationFields=" + this.serializationFields + ", deserializers=" + this.deserializers + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EquivalenceClass)) {
            return false;
        }
        EquivalenceClass other = (EquivalenceClass)o;
        if (this.size != other.size) {
            return false;
        }
        SerializationFieldInstantiation this$serializationFields = this.serializationFields;
        SerializationFieldInstantiation other$serializationFields = other.serializationFields;
        if (this$serializationFields == null ? other$serializationFields != null : !((Object)this$serializationFields).equals(other$serializationFields)) {
            return false;
        }
        List<TypeDeserializer> this$deserializers = this.deserializers;
        List<TypeDeserializer> other$deserializers = other.deserializers;
        return !(this$deserializers == null ? other$deserializers != null : !((Object)this$deserializers).equals(other$deserializers));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.size;
        SerializationFieldInstantiation $serializationFields = this.serializationFields;
        result = result * 59 + ($serializationFields == null ? 43 : ((Object)$serializationFields).hashCode());
        List<TypeDeserializer> $deserializers = this.deserializers;
        result = result * 59 + ($deserializers == null ? 43 : ((Object)$deserializers).hashCode());
        return result;
    }

    @Generated
    private EquivalenceClass(int size, List<TypeDeserializer> deserializers) {
        this.size = size;
        this.deserializers = deserializers;
    }
}

