/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.processing;

import de.quantummaid.mapmaid.Collection;
import de.quantummaid.mapmaid.builder.detection.SimpleDetector;
import de.quantummaid.mapmaid.builder.resolving.Report;
import de.quantummaid.mapmaid.builder.resolving.disambiguator.Disambiguators;
import de.quantummaid.mapmaid.builder.resolving.processing.CollectionResult;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.builder.resolving.processing.States;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.MapMaidException;
import de.quantummaid.mapmaid.debug.ScanInformationBuilder;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.validators.NotNullValidator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.StringJoiner;
import lombok.Generated;

public final class Processor {
    private States states;
    private final Queue<Signal> pendingSignals;

    public static Processor processor() {
        LinkedList<Signal> pendingSignals = new LinkedList<Signal>();
        States states = States.states(Collection.smallList());
        return new Processor(states, pendingSignals);
    }

    public void dispatch(Signal signal) {
        this.pendingSignals.add(signal);
    }

    public void addState(StatefulDefinition statefulDefinition) {
        NotNullValidator.validateNotNull(statefulDefinition, "statefulDefinition");
        this.states = this.states.addState(statefulDefinition);
    }

    public Map<TypeIdentifier, CollectionResult> collect(SimpleDetector detector, Disambiguators disambiguators) {
        this.resolveRecursively(detector, disambiguators);
        Map<TypeIdentifier, Report> reports = this.states.collect();
        HashMap<TypeIdentifier, ScanInformationBuilder> scanInformationBuilders = new HashMap<TypeIdentifier, ScanInformationBuilder>(reports.size());
        HashMap<TypeIdentifier, CollectionResult> definitions = new HashMap<TypeIdentifier, CollectionResult>(reports.size());
        Map<TypeIdentifier, Report> failures = Collection.smallMap();
        reports.forEach((type, report) -> {
            CollectionResult result = report.result();
            scanInformationBuilders.put((TypeIdentifier)type, result.scanInformation());
            if (report.isSuccess()) {
                definitions.put((TypeIdentifier)type, result);
            } else {
                failures.put((TypeIdentifier)type, (Report)report);
            }
        });
        if (!failures.isEmpty()) {
            DebugInformation debugInformation = DebugInformation.debugInformation(scanInformationBuilders);
            StringJoiner errorMessageJoiner = new StringJoiner("\n\n");
            ArrayList<ScanInformation> scanInformations = new ArrayList<ScanInformation>(failures.size());
            failures.forEach((typeIdentifier, report) -> {
                errorMessageJoiner.add(typeIdentifier.description() + ": " + report.errorMessage());
                ScanInformation scanInformation = debugInformation.scanInformationFor((TypeIdentifier)typeIdentifier);
                scanInformations.add(scanInformation);
            });
            String errorMessage = String.format("The following classes could not be detected properly:%n%n%s", errorMessageJoiner.toString());
            throw MapMaidException.mapMaidException(errorMessage, scanInformations);
        }
        return definitions;
    }

    private void resolveRecursively(SimpleDetector detector, Disambiguators disambiguators) {
        States resolved;
        List<TypeIdentifier> injectedTypes = this.states.injections();
        while (!this.pendingSignals.isEmpty()) {
            Signal signal = this.pendingSignals.remove();
            this.states = this.states.apply(signal, this);
        }
        States detected = this.states.apply(Signal.detect(detector, disambiguators, injectedTypes), this);
        this.states = resolved = detected.apply(Signal.resolve(), this);
        if (!this.pendingSignals.isEmpty()) {
            this.resolveRecursively(detector, disambiguators);
        }
    }

    @Generated
    public String toString() {
        return "Processor(states=" + this.states + ", pendingSignals=" + this.pendingSignals + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Processor)) {
            return false;
        }
        Processor other = (Processor)o;
        States this$states = this.states;
        States other$states = other.states;
        if (this$states == null ? other$states != null : !((Object)this$states).equals(other$states)) {
            return false;
        }
        Queue<Signal> this$pendingSignals = this.pendingSignals;
        Queue<Signal> other$pendingSignals = other.pendingSignals;
        return !(this$pendingSignals == null ? other$pendingSignals != null : !this$pendingSignals.equals(other$pendingSignals));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        States $states = this.states;
        result = result * 59 + ($states == null ? 43 : ((Object)$states).hashCode());
        Queue<Signal> $pendingSignals = this.pendingSignals;
        result = result * 59 + ($pendingSignals == null ? 43 : $pendingSignals.hashCode());
        return result;
    }

    @Generated
    private Processor(States states, Queue<Signal> pendingSignals) {
        this.states = states;
        this.pendingSignals = pendingSignals;
    }
}

