/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.builder.resolving.states;

import de.quantummaid.mapmaid.builder.resolving.Context;
import de.quantummaid.mapmaid.builder.resolving.processing.Signal;
import de.quantummaid.mapmaid.builder.resolving.states.StatefulDefinition;
import de.quantummaid.mapmaid.builder.resolving.states.undetected.UndetectedDuplex;
import de.quantummaid.mapmaid.builder.resolving.states.unreasoned.Unreasoned;
import de.quantummaid.mapmaid.debug.Reason;

public abstract class StatefulSerializer
extends StatefulDefinition {
    protected StatefulSerializer(Context context) {
        super(context);
    }

    @Override
    public StatefulDefinition addSerialization(Reason reason) {
        this.context.scanInformationBuilder().addSerializationReason(reason);
        return this;
    }

    @Override
    public StatefulDefinition removeSerialization(Reason reason) {
        boolean empty = this.context.removeSerializationReasonAndReturnIfEmpty(reason);
        if (empty) {
            return Unreasoned.unreasoned(this.context);
        }
        return this;
    }

    @Override
    public StatefulDefinition addDeserialization(Reason reason) {
        this.context.scanInformationBuilder().addDeserializationReason(reason);
        this.context.dispatch(Signal.removeSerialization(Reason.becauseOf(this.context.type())));
        return UndetectedDuplex.undetectedDuplex(this.context);
    }

    @Override
    public StatefulDefinition removeDeserialization(Reason reason) {
        return this;
    }
}

