/*
 * Decompiled with CFR 0.152.
 */
package de.quantummaid.mapmaid.mapper.deserialization.deserializers;

import de.quantummaid.mapmaid.debug.DebugInformation;
import de.quantummaid.mapmaid.debug.scaninformation.ScanInformation;
import de.quantummaid.mapmaid.mapper.deserialization.DeserializerCallback;
import de.quantummaid.mapmaid.mapper.deserialization.WrongInputStructure;
import de.quantummaid.mapmaid.mapper.deserialization.validation.ExceptionTracker;
import de.quantummaid.mapmaid.mapper.injector.Injector;
import de.quantummaid.mapmaid.mapper.schema.SchemaCallback;
import de.quantummaid.mapmaid.mapper.universal.Universal;
import de.quantummaid.mapmaid.shared.identifier.TypeIdentifier;
import de.quantummaid.mapmaid.shared.mapping.CustomPrimitiveMappings;
import java.util.List;

public interface TypeDeserializer {
    public List<TypeIdentifier> requiredTypes();

    public <T> T deserialize(Universal var1, ExceptionTracker var2, Injector var3, DeserializerCallback var4, CustomPrimitiveMappings var5, TypeIdentifier var6, DebugInformation var7);

    public String description();

    default public Universal schema(SchemaCallback schemaCallback) {
        throw new UnsupportedOperationException(String.format("Schema generation not supported for '%s'", this.description()));
    }

    public static <T extends Universal> T castSafely(Universal universalType, Class<T> type, ExceptionTracker exceptionTracker, TypeIdentifier resolvedType, DebugInformation debugInformation) {
        if (!type.isInstance(universalType)) {
            ScanInformation scanInformation = debugInformation.scanInformationFor(resolvedType);
            throw WrongInputStructure.wrongInputStructureException(type, universalType, exceptionTracker.getPosition(), scanInformation);
        }
        return (T)((Universal)type.cast(universalType));
    }
}

